/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.io.UnsupportedEncodingException;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReader;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactConsumer {
    private JoseHeadersReader reader = new JoseHeadersReaderWriter();
    private String encodedSequence;
    private String encodedSignature;
    private String headersJson;
    private String jwsPayload;

    public JwsCompactConsumer(String encodedJws) {
        this(encodedJws, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JwsCompactConsumer(String encodedJws, JoseHeadersReader r) {
        String[] parts;
        if (r != null) {
            this.reader = r;
        }
        if ((parts = encodedJws.split("\\.")).length != 3) {
            if (parts.length != 2 || !encodedJws.endsWith(".")) throw new SecurityException("Invalid JWS Compact sequence");
            this.encodedSignature = "";
        } else {
            this.encodedSignature = parts[2];
        }
        this.headersJson = JwsCompactConsumer.decodeToString(parts[0]);
        this.jwsPayload = JwsCompactConsumer.decodeToString(parts[1]);
        this.encodedSequence = parts[0] + "." + parts[1];
    }

    public String getUnsignedEncodedPayload() {
        return this.encodedSequence;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getDecodedJsonHeaders() {
        return this.headersJson;
    }

    public String getDecodedJwsPayload() {
        return this.jwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        try {
            return this.jwsPayload.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }

    public byte[] getDecodedSignature() {
        return this.encodedSignature.isEmpty() ? new byte[]{} : JwsCompactConsumer.decode(this.encodedSignature);
    }

    public JwsHeaders getJwsHeaders() {
        JoseHeaders joseHeaders = this.reader.fromJsonHeaders(this.headersJson);
        if (joseHeaders.getHeaderUpdateCount() != null) {
            throw new SecurityException();
        }
        return new JwsHeaders(joseHeaders);
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getJwsHeaders(), this.getUnsignedEncodedPayload(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    private static String decodeToString(String encoded) {
        try {
            return new String(JwsCompactConsumer.decode(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }

    protected JoseHeadersReader getReader() {
        return this.reader;
    }

    private static byte[] decode(String encoded) {
        try {
            return Base64UrlUtility.decode((String)encoded);
        }
        catch (Base64Exception ex) {
            throw new SecurityException(ex);
        }
    }
}

