/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactProducer {
    private JoseHeadersWriter writer = new JoseHeadersReaderWriter();
    private JwsHeaders headers;
    private String plainJwsPayload;
    private String signature;
    private String plainRep;

    public JwsCompactProducer(String plainJwsPayload) {
        this(null, null, plainJwsPayload);
    }

    public JwsCompactProducer(JwsHeaders headers, String plainJwsPayload) {
        this(headers, null, plainJwsPayload);
    }

    public JwsCompactProducer(JwsHeaders headers, JoseHeadersWriter w, String plainJwsPayload) {
        this.headers = headers;
        if (w != null) {
            this.writer = w;
        }
        this.plainJwsPayload = plainJwsPayload;
    }

    public JwsHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new JwsHeaders();
        }
        return this.headers;
    }

    public String getUnsignedEncodedJws() {
        this.checkAlgorithm();
        if (this.plainRep == null) {
            this.plainRep = Base64UrlUtility.encode((String)this.writer.headersToJson(this.getHeaders())) + "." + Base64UrlUtility.encode((String)this.plainJwsPayload);
        }
        return this.plainRep;
    }

    public String getSignedEncodedJws() {
        this.checkAlgorithm();
        boolean noSignature = StringUtils.isEmpty((String)this.signature);
        if (noSignature && !this.isPlainText()) {
            throw new IllegalStateException("Signature is not available");
        }
        return this.getUnsignedEncodedJws() + "." + (noSignature ? "" : this.signature);
    }

    public String signWith(JsonWebKey jwk) {
        return this.signWith(JwsUtils.getSignatureProvider(jwk));
    }

    public String signWith(JwsSignatureProvider signer) {
        JwsSignature worker = signer.createJwsSignature(this.getHeaders());
        try {
            byte[] bytes = this.getUnsignedEncodedJws().getBytes("UTF-8");
            worker.update(bytes, 0, bytes.length);
            this.signWith(worker.sign());
            return this.getSignedEncodedJws();
        }
        catch (Exception ex) {
            throw new SecurityException();
        }
    }

    public String signWith(String signatureText) {
        this.setEncodedSignature(Base64UrlUtility.encode((String)signatureText));
        return this.getSignedEncodedJws();
    }

    public String signWith(byte[] signatureOctets) {
        this.setEncodedSignature(Base64UrlUtility.encode((byte[])signatureOctets));
        return this.getSignedEncodedJws();
    }

    private void setEncodedSignature(String sig) {
        this.signature = sig;
    }

    private boolean isPlainText() {
        return "none".equals(this.getAlgorithm());
    }

    private String getAlgorithm() {
        return this.getHeaders().getAlgorithm();
    }

    private void checkAlgorithm() {
        if (this.getAlgorithm() == null) {
            throw new IllegalStateException("Algorithm header is not set");
        }
    }
}

