/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtHeaders;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReaderWriter;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenWriter;

public class JwsJwtCompactProducer
extends JwsCompactProducer {
    public JwsJwtCompactProducer(JwtToken token) {
        this(token, null);
    }

    public JwsJwtCompactProducer(JwtClaims claims) {
        this(new JwtToken(null, claims), null);
    }

    public JwsJwtCompactProducer(JwtHeaders headers, JwtClaims claims) {
        this(headers, claims, null);
    }

    public JwsJwtCompactProducer(JwtHeaders headers, JwtClaims claims, JwtTokenWriter w) {
        this(new JwtToken(headers, claims), w);
    }

    public JwsJwtCompactProducer(JwtToken token, JwtTokenWriter w) {
        super(new JwsHeaders(token.getHeaders().asMap()), w, JwsJwtCompactProducer.serializeClaims(token.getClaims(), w));
    }

    private static String serializeClaims(JwtClaims claims, JwtTokenWriter writer) {
        if (writer == null) {
            writer = new JwtTokenReaderWriter();
        }
        return writer.claimsToJson(claims);
    }
}

