/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.AbstractJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public final class JwsUtils {
    private JwsUtils() {
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk) {
        return JwsUtils.getSignatureProvider(jwk, null);
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk, String defaultAlgorithm) {
        String rsaSignatureAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        AbstractJwsSignatureProvider theSigProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            theSigProvider = new PrivateKeyJwsSignatureProvider(JwkUtils.toRSAPrivateKey(jwk), rsaSignatureAlgo);
        } else if ("oct".equals(jwk.getKeyType()) && Algorithm.isHmacSign(rsaSignatureAlgo)) {
            theSigProvider = new HmacJwsSignatureProvider((String)jwk.getProperty("k"), rsaSignatureAlgo);
        } else if ("EC".equals(jwk.getKeyType())) {
            theSigProvider = new EcDsaJwsSignatureProvider(JwkUtils.toECPrivateKey(jwk), rsaSignatureAlgo);
        }
        return theSigProvider;
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk) {
        return JwsUtils.getSignatureVerifier(jwk, null);
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk, String defaultAlgorithm) {
        String rsaSignatureAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        JwsSignatureVerifier theVerifier = null;
        if ("RSA".equals(jwk.getKeyType())) {
            theVerifier = new PublicKeyJwsSignatureVerifier(JwkUtils.toRSAPublicKey(jwk), rsaSignatureAlgo);
        } else if ("oct".equals(jwk.getKeyType()) && Algorithm.isHmacSign(rsaSignatureAlgo)) {
            theVerifier = new HmacJwsSignatureVerifier((String)jwk.getProperty("k"), rsaSignatureAlgo);
        } else if ("EC".equals(jwk.getKeyType())) {
            theVerifier = new EcDsaJwsSignatureVerifier(JwkUtils.toECPublicKey(jwk), rsaSignatureAlgo);
        }
        return theVerifier;
    }
}

