/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.AbstractJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;

public class PrivateKeyJwsSignatureProvider
extends AbstractJwsSignatureProvider {
    private PrivateKey key;
    private SecureRandom random;
    private AlgorithmParameterSpec signatureSpec;

    public PrivateKeyJwsSignatureProvider(PrivateKey key, String algo) {
        this(key, null, algo);
    }

    public PrivateKeyJwsSignatureProvider(PrivateKey key, AlgorithmParameterSpec spec, String algo) {
        this(key, null, spec, algo);
    }

    public PrivateKeyJwsSignatureProvider(PrivateKey key, SecureRandom random, AlgorithmParameterSpec spec, String algo) {
        super(algo);
        this.key = key;
        this.random = random;
        this.signatureSpec = spec;
    }

    @Override
    protected JwsSignature doCreateJwsSignature(JwsHeaders headers) {
        final Signature s = CryptoUtils.getSignature((PrivateKey)this.key, (String)Algorithm.toJavaName(headers.getAlgorithm()), (SecureRandom)this.random, (AlgorithmParameterSpec)this.signatureSpec);
        return new JwsSignature(){

            @Override
            public void update(byte[] src, int off, int len) {
                try {
                    s.update(src, off, len);
                }
                catch (SignatureException ex) {
                    throw new SecurityException();
                }
            }

            @Override
            public byte[] sign() {
                try {
                    return s.sign();
                }
                catch (SignatureException ex) {
                    throw new SecurityException();
                }
            }
        };
    }

    @Override
    protected void checkAlgorithm(String algo) {
        super.checkAlgorithm(algo);
        if (!this.isValidAlgorithmFamily(algo)) {
            throw new SecurityException();
        }
    }

    protected boolean isValidAlgorithmFamily(String algo) {
        return Algorithm.isRsaShaSign(algo);
    }
}

