/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtHeaders;

public class PublicKeyJwsSignatureVerifier
implements JwsSignatureVerifier {
    private PublicKey key;
    private AlgorithmParameterSpec signatureSpec;
    private String supportedAlgo;

    public PublicKeyJwsSignatureVerifier(PublicKey key) {
        this(key, null);
    }

    public PublicKeyJwsSignatureVerifier(PublicKey key, String supportedAlgorithm) {
        this(key, null, supportedAlgorithm);
    }

    public PublicKeyJwsSignatureVerifier(PublicKey key, AlgorithmParameterSpec spec, String supportedAlgo) {
        this.key = key;
        this.signatureSpec = spec;
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    public boolean verify(JwtHeaders headers, String unsignedText, byte[] signature) {
        try {
            return CryptoUtils.verifySignature((byte[])unsignedText.getBytes("UTF-8"), (byte[])signature, (PublicKey)this.key, (String)Algorithm.toJavaName(this.checkAlgorithm(headers.getAlgorithm())), (AlgorithmParameterSpec)this.signatureSpec);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    protected String checkAlgorithm(String algo) {
        if (algo == null || !this.isValidAlgorithmFamily(algo) || this.supportedAlgo != null && !this.supportedAlgo.equals(algo)) {
            throw new SecurityException();
        }
        return algo;
    }

    protected boolean isValidAlgorithmFamily(String algo) {
        return Algorithm.isRsaShaSign(algo);
    }
}

