/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtHeaders;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenJson;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReader;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenWriter;

public class JwtTokenReaderWriter
extends JoseHeadersReaderWriter
implements JwtTokenReader,
JwtTokenWriter {
    @Override
    public String claimsToJson(JwtClaims claims) {
        return this.toJson(claims);
    }

    @Override
    public JwtTokenJson tokenToJson(JwtToken token) {
        return new JwtTokenJson(this.toJson(token.getHeaders()), this.toJson(token.getClaims()));
    }

    @Override
    public JwtClaims fromJsonClaims(String claimsJson) {
        JwtClaims claims = new JwtClaims();
        this.fromJsonInternal(claims, claimsJson);
        return claims;
    }

    private JwtToken fromJson(String headersJson, String claimsJson) {
        JwtHeaders headers = this.fromJsonHeaders(headersJson);
        JwtClaims claims = this.fromJsonClaims(claimsJson);
        return new JwtToken(headers, claims);
    }

    @Override
    public JwtToken fromJson(JwtTokenJson pair) {
        return this.fromJson(pair.getHeadersJson(), pair.getClaimsJson());
    }

    @Override
    public JwtHeaders fromJsonHeaders(String jsonHeaders) {
        return new JwtHeaders(super.fromJsonHeaders(jsonHeaders));
    }
}

