/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsWriterProvider {
    private static final String JWS_CONTEXT_PROPERTY = "org.apache.cxf.jws.context";
    private JwsSignatureProvider sigProvider;

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider(JoseHeaders headers) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(true);
        headers.setAlgorithm(theSigProvider.getAlgorithm());
        return theSigProvider;
    }

    protected void setRequestContextProperty(Message m, JoseHeaders headers) {
        String context = (String)m.getContextualProperty(JWS_CONTEXT_PROPERTY);
        if (context != null) {
            headers.setHeader(JWS_CONTEXT_PROPERTY, context);
        }
    }

    protected void writeJws(JwsCompactProducer p, JwsSignatureProvider theSigProvider, OutputStream os) throws IOException {
        p.signWith(theSigProvider);
        byte[] bytes = StringUtils.toBytesUTF8((String)p.getSignedEncodedJws());
        IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)os);
    }
}

