/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@Priority(value=1000)
public class JwsClientResponseFilter
extends AbstractJwsReaderProvider
implements ClientResponseFilter {
    public void filter(ClientRequestContext req, ClientResponseContext res) throws IOException {
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        JwsCompactConsumer p = new JwsCompactConsumer(IOUtils.readStringFromStream((InputStream)res.getEntityStream()));
        if (!p.verifySignatureWith(theSigVerifier)) {
            throw new SecurityException();
        }
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        res.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        res.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(p.getJoseHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            res.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }
}

