/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.JoseHeadersReader;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public abstract class AbstractJweDecryption
implements JweDecryptionProvider {
    private KeyDecryptionAlgorithm keyDecryptionAlgo;
    private ContentDecryptionAlgorithm contentDecryptionAlgo;
    private JoseHeadersReader reader = new JoseHeadersReaderWriter();

    protected AbstractJweDecryption(JoseHeadersReader theReader, KeyDecryptionAlgorithm keyDecryptionAlgo, ContentDecryptionAlgorithm contentDecryptionAlgo) {
        if (theReader != null) {
            this.reader = theReader;
        }
        this.keyDecryptionAlgo = keyDecryptionAlgo;
        this.contentDecryptionAlgo = contentDecryptionAlgo;
    }

    protected byte[] getContentEncryptionKey(JweCompactConsumer consumer) {
        return this.keyDecryptionAlgo.getDecryptedContentEncryptionKey(consumer);
    }

    @Override
    public JweDecryptionOutput decrypt(String content) {
        JweCompactConsumer consumer = new JweCompactConsumer(content, this.reader);
        return this.doDecrypt(consumer);
    }

    @Override
    public byte[] decrypt(JweCompactConsumer consumer) {
        return this.doDecrypt(consumer).getContent();
    }

    protected JweDecryptionOutput doDecrypt(JweCompactConsumer consumer) {
        byte[] cek = this.getContentEncryptionKey(consumer);
        return this.doDecrypt(consumer, cek);
    }

    protected JweDecryptionOutput doDecrypt(JweCompactConsumer consumer, byte[] cek) {
        KeyProperties keyProperties = new KeyProperties(this.getContentEncryptionAlgorithm(consumer));
        keyProperties.setAdditionalData(this.getContentEncryptionCipherAAD(consumer));
        AlgorithmParameterSpec spec = this.getContentEncryptionCipherSpec(consumer);
        keyProperties.setAlgoSpec(spec);
        boolean compressionSupported = "DEF".equals(consumer.getJweHeaders().getZipAlgorithm());
        keyProperties.setCompressionSupported(compressionSupported);
        byte[] actualCek = this.getActualCek(cek, consumer.getJweHeaders().getContentEncryptionAlgorithm());
        SecretKey secretKey = CryptoUtils.createSecretKeySpec((byte[])actualCek, (String)keyProperties.getKeyAlgo());
        byte[] bytes = CryptoUtils.decryptBytes((byte[])this.getEncryptedContentWithAuthTag(consumer), (Key)secretKey, (KeyProperties)keyProperties);
        return new JweDecryptionOutput(consumer.getJweHeaders(), bytes);
    }

    protected byte[] getEncryptedContentEncryptionKey(JweCompactConsumer consumer) {
        return consumer.getEncryptedContentEncryptionKey();
    }

    protected AlgorithmParameterSpec getContentEncryptionCipherSpec(JweCompactConsumer consumer) {
        return this.contentDecryptionAlgo.getAlgorithmParameterSpec(this.getContentEncryptionCipherInitVector(consumer));
    }

    protected String getContentEncryptionAlgorithm(JweCompactConsumer consumer) {
        return Algorithm.toJavaName(consumer.getJweHeaders().getContentEncryptionAlgorithm());
    }

    protected byte[] getContentEncryptionCipherAAD(JweCompactConsumer consumer) {
        return this.contentDecryptionAlgo.getAdditionalAuthenticationData(consumer.getDecodedJsonHeaders());
    }

    protected byte[] getEncryptedContentWithAuthTag(JweCompactConsumer consumer) {
        return this.contentDecryptionAlgo.getEncryptedSequence(consumer.getJweHeaders(), consumer.getEncryptedContent(), this.getEncryptionAuthenticationTag(consumer));
    }

    protected byte[] getContentEncryptionCipherInitVector(JweCompactConsumer consumer) {
        return consumer.getContentDecryptionCipherInitVector();
    }

    protected byte[] getEncryptionAuthenticationTag(JweCompactConsumer consumer) {
        return consumer.getEncryptionAuthenticationTag();
    }

    protected int getEncryptionAuthenticationTagLenBits(JweCompactConsumer consumer) {
        return this.getEncryptionAuthenticationTag(consumer).length * 8;
    }

    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return theCek;
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyDecryptionAlgo.getAlgorithm();
    }

    @Override
    public String getContentAlgorithm() {
        return this.contentDecryptionAlgo.getAlgorithm();
    }
}

