/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionState;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;

public abstract class AbstractJweEncryption
implements JweEncryptionProvider {
    protected static final int DEFAULT_AUTH_TAG_LENGTH = 128;
    private JweHeaders headers;
    private JoseHeadersWriter writer;
    private ContentEncryptionAlgorithm contentEncryptionAlgo;
    private KeyEncryptionAlgorithm keyEncryptionAlgo;

    protected AbstractJweEncryption(JweHeaders headers, ContentEncryptionAlgorithm contentEncryptionAlgo, KeyEncryptionAlgorithm keyEncryptionAlgo) {
        this(headers, contentEncryptionAlgo, keyEncryptionAlgo, null);
    }

    protected AbstractJweEncryption(JweHeaders headers, ContentEncryptionAlgorithm contentEncryptionAlgo, KeyEncryptionAlgorithm keyEncryptionAlgo, JoseHeadersWriter writer) {
        this.headers = headers;
        this.writer = writer;
        if (this.writer == null) {
            this.writer = new JoseHeadersReaderWriter();
        }
        this.keyEncryptionAlgo = keyEncryptionAlgo;
        this.contentEncryptionAlgo = contentEncryptionAlgo;
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return this.contentEncryptionAlgo.getAlgorithmParameterSpec(theIv);
    }

    protected byte[] getContentEncryptionKey() {
        byte[] cek = this.getProvidedContentEncryptionKey();
        if (cek == null) {
            String algoJava = this.getContentEncryptionAlgoJava();
            String algoJwt = this.getContentEncryptionAlgoJwt();
            cek = CryptoUtils.getSecretKey((String)Algorithm.stripAlgoProperties(algoJava), (int)this.getCekSize(algoJwt)).getEncoded();
        }
        return cek;
    }

    protected int getCekSize(String algoJwt) {
        return Algorithm.valueOf(algoJwt.replace('-', '_')).getKeySizeBits();
    }

    protected byte[] getProvidedContentEncryptionKey() {
        return this.contentEncryptionAlgo.getContentEncryptionKey(this.headers);
    }

    protected byte[] getEncryptedContentEncryptionKey(byte[] theCek) {
        return this.keyEncryptionAlgo.getEncryptedContentEncryptionKey(this.headers, theCek);
    }

    protected String getContentEncryptionAlgoJwt() {
        return this.headers.getContentEncryptionAlgorithm();
    }

    protected String getContentEncryptionAlgoJava() {
        return Algorithm.toJavaName(this.getContentEncryptionAlgoJwt());
    }

    protected byte[] getAAD(JweHeaders theHeaders) {
        return this.contentEncryptionAlgo.getAdditionalAuthenticationData(this.writer.headersToJson(theHeaders));
    }

    @Override
    public String encrypt(byte[] content, JweHeaders jweHeaders) {
        JweEncryptionInternal state = this.getInternalState(jweHeaders);
        byte[] cipher = CryptoUtils.encryptBytes((byte[])content, (Key)this.createCekSecretKey(state), (KeyProperties)state.keyProps);
        JweCompactProducer producer = this.getJweCompactProducer(state, cipher);
        return producer.getJweContent();
    }

    protected JweCompactProducer getJweCompactProducer(JweEncryptionInternal state, byte[] cipher) {
        return new JweCompactProducer(state.theHeaders, this.getJwtHeadersWriter(), state.jweContentEncryptionKey, state.theIv, cipher, 128);
    }

    protected JoseHeadersWriter getJwtHeadersWriter() {
        return this.writer;
    }

    protected JweHeaders getJweHeaders() {
        return this.headers;
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyEncryptionAlgo.getAlgorithm();
    }

    @Override
    public String getContentAlgorithm() {
        return this.contentEncryptionAlgo.getAlgorithm();
    }

    @Override
    public JweEncryptionState createJweEncryptionState(JweHeaders jweHeaders) {
        JweEncryptionInternal state = this.getInternalState(jweHeaders);
        Cipher c = CryptoUtils.initCipher((Key)this.createCekSecretKey(state), (KeyProperties)state.keyProps, (int)1);
        return new JweEncryptionState(c, state.theHeaders, state.jweContentEncryptionKey, state.theIv, this.getAuthenticationTagProducer(state), state.keyProps.isCompressionSupported());
    }

    protected AuthenticationTagProducer getAuthenticationTagProducer(JweEncryptionInternal state) {
        return null;
    }

    protected SecretKey createCekSecretKey(JweEncryptionInternal state) {
        return CryptoUtils.createSecretKeySpec((byte[])this.getActualCek(state.secretKey, this.getContentEncryptionAlgoJwt()), (String)state.keyProps.getKeyAlgo());
    }

    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return theCek;
    }

    private JweEncryptionInternal getInternalState(JweHeaders jweHeaders) {
        byte[] theCek = this.getContentEncryptionKey();
        String contentEncryptionAlgoJavaName = Algorithm.toJavaName(this.headers.getContentEncryptionAlgorithm());
        KeyProperties keyProps = new KeyProperties(contentEncryptionAlgoJavaName);
        keyProps.setCompressionSupported(this.compressionRequired(this.headers));
        byte[] theIv = this.contentEncryptionAlgo.getInitVector();
        AlgorithmParameterSpec specParams = this.getAlgorithmParameterSpec(theIv);
        keyProps.setAlgoSpec(specParams);
        byte[] jweContentEncryptionKey = this.getEncryptedContentEncryptionKey(theCek);
        JweHeaders theHeaders = this.headers;
        if (jweHeaders != null) {
            if (jweHeaders.getKeyEncryptionAlgorithm() != null && !this.keyEncryptionAlgo.getAlgorithm().equals(jweHeaders.getKeyEncryptionAlgorithm()) || jweHeaders.getAlgorithm() != null && !this.contentEncryptionAlgo.getAlgorithm().equals(jweHeaders.getAlgorithm())) {
                throw new SecurityException();
            }
            theHeaders = new JweHeaders(theHeaders.asMap());
            theHeaders.asMap().putAll(jweHeaders.asMap());
        }
        byte[] additionalEncryptionParam = this.getAAD(theHeaders);
        keyProps.setAdditionalData(additionalEncryptionParam);
        JweEncryptionInternal state = new JweEncryptionInternal();
        state.theHeaders = theHeaders;
        state.jweContentEncryptionKey = jweContentEncryptionKey;
        state.keyProps = keyProps;
        state.secretKey = theCek;
        state.theIv = theIv;
        return state;
    }

    private boolean compressionRequired(JweHeaders theHeaders) {
        return "DEF".equals(theHeaders.getZipAlgorithm());
    }

    protected KeyEncryptionAlgorithm getKeyEncryptionAlgo() {
        return this.keyEncryptionAlgo;
    }

    protected static class JweEncryptionInternal {
        JweHeaders theHeaders;
        byte[] jweContentEncryptionKey;
        byte[] theIv;
        KeyProperties keyProps;
        byte[] secretKey;

        protected JweEncryptionInternal() {
        }
    }
}

