/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionAlgorithm;

public class AesGcmContentEncryptionAlgorithm
extends AbstractContentEncryptionAlgorithm {
    private static final int DEFAULT_IV_SIZE = 96;

    public AesGcmContentEncryptionAlgorithm(String algo) {
        this((byte[])null, null, algo);
    }

    public AesGcmContentEncryptionAlgorithm(String encodedCek, String encodedIv, String algo) {
        this(CryptoUtils.decodeSequence((String)encodedCek), CryptoUtils.decodeSequence((String)encodedIv), algo);
    }

    public AesGcmContentEncryptionAlgorithm(SecretKey key, byte[] iv, String algo) {
        this(key.getEncoded(), iv, algo);
    }

    public AesGcmContentEncryptionAlgorithm(byte[] cek, byte[] iv, String algo) {
        super(cek, iv, AesGcmContentEncryptionAlgorithm.checkAlgorithm(algo));
    }

    @Override
    protected int getIvSize() {
        return 96;
    }

    private static String checkAlgorithm(String algo) {
        if (Algorithm.isAesGcm(algo)) {
            return algo;
        }
        throw new SecurityException();
    }
}

