/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;

public class AesGcmWrapKeyDecryptionAlgorithm
extends WrappedKeyDecryptionAlgorithm {
    public AesGcmWrapKeyDecryptionAlgorithm(String encodedKey) {
        this(encodedKey, null);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(String encodedKey, String supportedAlgo) {
        this(CryptoUtils.decodeSequence((String)encodedKey), supportedAlgo);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(byte[] secretKey) {
        this(secretKey, null);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(byte[] secretKey, String supportedAlgo) {
        this(CryptoUtils.createSecretKeySpec((byte[])secretKey, (String)"AES"), supportedAlgo);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(SecretKey secretKey) {
        this(secretKey, null);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(SecretKey secretKey, String supportedAlgo) {
        super(secretKey, supportedAlgo);
    }

    @Override
    protected byte[] getEncryptedContentEncryptionKey(JweCompactConsumer consumer) {
        byte[] encryptedCekKey = super.getEncryptedContentEncryptionKey(consumer);
        byte[] tag = this.getDecodedBytes(consumer, "tag");
        return JweCompactConsumer.getCipherWithAuthTag(encryptedCekKey, tag);
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweCompactConsumer consumer) {
        byte[] iv = this.getDecodedBytes(consumer, "iv");
        return CryptoUtils.getContentEncryptionCipherSpec((int)128, (byte[])iv);
    }

    private byte[] getDecodedBytes(JweCompactConsumer consumer, String headerName) {
        try {
            Object ivHeader = consumer.getJweHeaders().getHeader(headerName);
            return Base64UrlUtility.decode((String)ivHeader.toString());
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    @Override
    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        super.validateKeyEncryptionAlgorithm(keyAlgo);
        if (!Algorithm.isAesGcmKeyWrap(keyAlgo)) {
            throw new SecurityException();
        }
    }
}

