/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.Map;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;

public class JweHeaders
extends JoseHeaders {
    public JweHeaders() {
    }

    public JweHeaders(JoseHeaders headers) {
        super(headers.asMap());
    }

    public JweHeaders(Map<String, Object> values) {
        super(values);
    }

    public JweHeaders(String keyEncAlgo, String ctEncAlgo) {
        this(keyEncAlgo, ctEncAlgo, false);
    }

    public JweHeaders(String ctEncAlgo) {
        this(null, ctEncAlgo, false);
    }

    public JweHeaders(String ctEncAlgo, boolean deflate) {
        this(null, ctEncAlgo, deflate);
    }

    public JweHeaders(String keyEncAlgo, String ctEncAlgo, boolean deflate) {
        this.init(keyEncAlgo, ctEncAlgo, deflate);
    }

    private void init(String keyEncAlgo, String ctEncAlgo, boolean deflate) {
        if (keyEncAlgo != null) {
            this.setKeyEncryptionAlgorithm(keyEncAlgo);
        }
        this.setContentEncryptionAlgorithm(ctEncAlgo);
        if (deflate) {
            this.setZipAlgorithm("DEF");
        }
    }

    public void setKeyEncryptionAlgorithm(String type) {
        super.setAlgorithm(type);
    }

    public String getKeyEncryptionAlgorithm() {
        return super.getAlgorithm();
    }

    public void setContentEncryptionAlgorithm(String type) {
        this.setHeader("enc", type);
    }

    public String getContentEncryptionAlgorithm() {
        return (String)this.getHeader("enc");
    }

    public void setZipAlgorithm(String type) {
        this.setHeader("zip", type);
    }

    public String getZipAlgorithm() {
        return (String)this.getHeader("zip");
    }

    @Override
    public JoseHeaders setHeader(String name, Object value) {
        return super.setHeader(name, value);
    }

    public byte[] toCipherAdditionalAuthData(JoseHeadersWriter writer) {
        return JweHeaders.toCipherAdditionalAuthData(writer.headersToJson(this));
    }

    public static byte[] toCipherAdditionalAuthData(String headersJson) {
        byte[] headerBytes = StringUtils.toBytesUTF8((String)headersJson);
        String base64UrlHeadersInJson = Base64UrlUtility.encode((byte[])headerBytes);
        return StringUtils.toBytesASCII((String)base64UrlHeadersInJson);
    }
}

