/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReaderWriter;

public class JweJwtCompactConsumer {
    private JweCompactConsumer jweConsumer;
    private JweHeaders headers;

    public JweJwtCompactConsumer(String content) {
        this.jweConsumer = new JweCompactConsumer(content);
        this.headers = this.jweConsumer.getJweHeaders();
    }

    public JwtToken decryptWith(JsonWebKey key) {
        return this.decryptWith(JweUtils.createJweDecryptionProvider(key, this.headers.getContentEncryptionAlgorithm()));
    }

    public JwtToken decryptWith(RSAPrivateKey key) {
        return this.decryptWith(JweUtils.createJweDecryptionProvider(key, this.headers.getKeyEncryptionAlgorithm(), this.headers.getContentEncryptionAlgorithm()));
    }

    public JwtToken decryptWith(SecretKey key) {
        return this.decryptWith(JweUtils.createJweDecryptionProvider(key, this.headers.getKeyEncryptionAlgorithm(), this.headers.getContentEncryptionAlgorithm()));
    }

    public JwtToken decryptWith(JweDecryptionProvider jwe) {
        byte[] bytes = jwe.decrypt(this.jweConsumer);
        JwtClaims claims = new JwtTokenReaderWriter().fromJsonClaims(JweJwtCompactConsumer.toString(bytes));
        return new JwtToken(this.headers, claims);
    }

    private static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

