/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.RSAPrivateKey;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;

public class RSAOaepKeyDecryptionAlgorithm
extends WrappedKeyDecryptionAlgorithm {
    public RSAOaepKeyDecryptionAlgorithm(RSAPrivateKey privateKey) {
        this(privateKey, null);
    }

    public RSAOaepKeyDecryptionAlgorithm(RSAPrivateKey privateKey, String supportedAlgo) {
        this(privateKey, supportedAlgo, true);
    }

    public RSAOaepKeyDecryptionAlgorithm(RSAPrivateKey privateKey, String supportedAlgo, boolean unwrap) {
        super(privateKey, supportedAlgo, unwrap);
    }

    @Override
    protected int getKeyCipherBlockSize() {
        return ((RSAPrivateKey)this.getCekDecryptionKey()).getModulus().toByteArray().length;
    }

    @Override
    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        super.validateKeyEncryptionAlgorithm(keyAlgo);
        if (!Algorithm.isRsaOaep(keyAlgo)) {
            throw new SecurityException();
        }
    }
}

