/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;

public class EcDsaJwsSignatureProvider
extends PrivateKeyJwsSignatureProvider {
    public EcDsaJwsSignatureProvider(ECPrivateKey key, String algo) {
        this(key, null, algo);
    }

    public EcDsaJwsSignatureProvider(ECPrivateKey key, AlgorithmParameterSpec spec, String algo) {
        this(key, null, spec, algo);
    }

    public EcDsaJwsSignatureProvider(ECPrivateKey key, SecureRandom random, AlgorithmParameterSpec spec, String algo) {
        super(key, random, spec, algo);
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return Algorithm.isEcDsaSign(algo);
    }

    @Override
    protected JwsSignature doCreateJwsSignature(Signature s) {
        return new EcDsaPrivateKeyJwsSignature(s);
    }

    private static byte[] jcaOutputToJoseOutput(byte[] jcaDer) {
        byte rPartLen = jcaDer[3];
        int rOffset = rPartLen % 8;
        int rValueStart = 4 + rOffset;
        int sPartStart = 4 + rPartLen;
        byte sPartLen = jcaDer[sPartStart + 1];
        int sOffset = sPartLen % 8;
        int sValueStart = sPartStart + 2 + sOffset;
        int partLen = rPartLen - rOffset;
        byte[] result = new byte[partLen * 2];
        System.arraycopy(jcaDer, rValueStart, result, 0, partLen);
        System.arraycopy(jcaDer, sValueStart, result, partLen, partLen);
        return result;
    }

    protected static class EcDsaPrivateKeyJwsSignature
    extends PrivateKeyJwsSignatureProvider.PrivateKeyJwsSignature {
        public EcDsaPrivateKeyJwsSignature(Signature s) {
            super(s);
        }

        @Override
        public byte[] sign() {
            byte[] der = super.sign();
            return EcDsaJwsSignatureProvider.jcaOutputToJoseOutput(der);
        }
    }
}

