/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.apache.cxf.common.util.crypto.HmacUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

public class HmacJwsSignatureVerifier
implements JwsSignatureVerifier {
    private byte[] key;
    private AlgorithmParameterSpec hmacSpec;
    private String supportedAlgo;

    public HmacJwsSignatureVerifier(String encodedKey) {
        this(JoseUtils.decode(encodedKey), "HS256");
    }

    public HmacJwsSignatureVerifier(String encodedKey, String supportedAlgo) {
        this(JoseUtils.decode(encodedKey), supportedAlgo);
    }

    public HmacJwsSignatureVerifier(byte[] key, String supportedAlgo) {
        this(key, null, supportedAlgo);
    }

    public HmacJwsSignatureVerifier(byte[] key, AlgorithmParameterSpec spec, String supportedAlgo) {
        this.key = key;
        this.hmacSpec = spec;
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    public boolean verify(JoseHeaders headers, String unsignedText, byte[] signature) {
        byte[] expected = this.computeMac(headers, unsignedText);
        return Arrays.equals(expected, signature);
    }

    private byte[] computeMac(JoseHeaders headers, String text) {
        return HmacUtils.computeHmac((byte[])this.key, (String)Algorithm.toJavaName(this.checkAlgorithm(headers.getAlgorithm())), (AlgorithmParameterSpec)this.hmacSpec, (String)text);
    }

    protected String checkAlgorithm(String algo) {
        if (algo == null || !Algorithm.isHmacSign(algo) || !algo.equals(this.supportedAlgo)) {
            throw new SecurityException();
        }
        return algo;
    }

    @Override
    public String getAlgorithm() {
        return this.supportedAlgo;
    }
}

