/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.interfaces.RSAPublicKey;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReader;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactConsumer {
    private JoseHeadersReader reader = new JoseHeadersReaderWriter();
    private String encodedSequence;
    private String encodedSignature;
    private String headersJson;
    private String jwsPayload;

    public JwsCompactConsumer(String encodedJws) {
        this(encodedJws, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JwsCompactConsumer(String encodedJws, JoseHeadersReader r) {
        String[] parts;
        if (r != null) {
            this.reader = r;
        }
        if (encodedJws.startsWith("\"") && encodedJws.endsWith("\"")) {
            encodedJws = encodedJws.substring(1, encodedJws.length() - 1);
        }
        if ((parts = encodedJws.split("\\.")).length != 3) {
            if (parts.length != 2 || !encodedJws.endsWith(".")) throw new SecurityException("Invalid JWS Compact sequence");
            this.encodedSignature = "";
        } else {
            this.encodedSignature = parts[2];
        }
        this.headersJson = JoseUtils.decodeToString(parts[0]);
        this.jwsPayload = JoseUtils.decodeToString(parts[1]);
        this.encodedSequence = parts[0] + "." + parts[1];
    }

    public String getUnsignedEncodedSequence() {
        return this.encodedSequence;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getDecodedJsonHeaders() {
        return this.headersJson;
    }

    public String getDecodedJwsPayload() {
        return this.jwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.jwsPayload);
    }

    public byte[] getDecodedSignature() {
        return this.encodedSignature.isEmpty() ? new byte[]{} : JoseUtils.decode(this.encodedSignature);
    }

    public JoseHeaders getJoseHeaders() {
        JoseHeaders joseHeaders = this.reader.fromJsonHeaders(this.headersJson);
        if (joseHeaders.getUpdateCount() != null) {
            throw new SecurityException("Duplicate headers have been detected");
        }
        return joseHeaders;
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getJoseHeaders(), this.getUnsignedEncodedSequence(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean verifySignatureWith(RSAPublicKey key, String algo) {
        return this.verifySignatureWith(JwsUtils.getRSAKeySignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(byte[] key, String algo) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo));
    }

    public boolean validateCriticalHeaders() {
        return JwsUtils.validateCriticalHeaders(this.getJoseHeaders());
    }

    protected JoseHeadersReader getReader() {
        return this.reader;
    }
}

