/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProtectedHeader;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsJsonUnprotectedHeader;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonProducer {
    private String plainPayload;
    private String encodedPayload;
    private StringBuilder jwsJsonSignedDocBuilder = new StringBuilder();
    private List<JwsJsonSignatureEntry> signatures = new LinkedList<JwsJsonSignatureEntry>();

    public JwsJsonProducer(String tbsDocument) {
        this.plainPayload = tbsDocument;
        this.encodedPayload = Base64UrlUtility.encode((String)tbsDocument);
    }

    public JwsJsonProducer(String tbsDocument, List<JwsJsonSignatureEntry> signatures) {
        this(tbsDocument);
        for (JwsJsonSignatureEntry entry : signatures) {
            this.updateJwsJsonSignedDocument(entry);
        }
    }

    public String getPlainPayload() {
        return this.plainPayload;
    }

    public String getUnsignedEncodedPayload() {
        return this.encodedPayload;
    }

    public String getJwsJsonSignedDocument() {
        if (this.signatures.isEmpty()) {
            throw new SecurityException("Signature is not available");
        }
        return this.jwsJsonSignedDocBuilder.toString() + "]}";
    }

    public List<JwsJsonSignatureEntry> getSignatureEntries() {
        return Collections.unmodifiableList(this.signatures);
    }

    public MultivaluedMap<String, JwsJsonSignatureEntry> getSignatureEntryMap() {
        return JwsUtils.getJwsJsonSignatureMap(this.signatures);
    }

    public String signWith(List<JwsSignatureProvider> signers) {
        for (JwsSignatureProvider signer : signers) {
            this.signWith(signer);
        }
        return this.getJwsJsonSignedDocument();
    }

    public String signWith(JwsSignatureProvider signer) {
        JoseHeaders headers = new JoseHeaders();
        headers.setAlgorithm(signer.getAlgorithm());
        return this.signWith(signer, new JwsJsonProtectedHeader(headers));
    }

    public String signWith(JwsSignatureProvider signer, JwsJsonProtectedHeader protectedHeader) {
        return this.signWith(signer, protectedHeader, null);
    }

    public String signWith(JsonWebKey jwk) {
        return this.signWith(JwsUtils.getSignatureProvider(jwk));
    }

    public String signWith(RSAPrivateKey key, String algo) {
        return this.signWith(JwsUtils.getRSAKeySignatureProvider(key, algo));
    }

    public String signWith(byte[] key, String algo) {
        return this.signWith(JwsUtils.getHmacSignatureProvider(key, algo));
    }

    public String signWith(JwsSignatureProvider signer, JwsJsonProtectedHeader protectedHeader, JwsJsonUnprotectedHeader unprotectedHeader) {
        JoseHeaders unionHeaders = new JoseHeaders();
        if (protectedHeader != null) {
            unionHeaders.asMap().putAll(protectedHeader.getHeaderEntries().asMap());
        }
        if (unprotectedHeader != null) {
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), unprotectedHeader.getHeaderEntries().asMap().keySet())) {
                throw new SecurityException("Protected and unprotected headers have duplicate values");
            }
            unionHeaders.asMap().putAll(unprotectedHeader.getHeaderEntries().asMap());
        }
        if (unionHeaders.getAlgorithm() == null) {
            throw new SecurityException("Algorithm header is not set");
        }
        String sequenceToBeSigned = protectedHeader.getEncodedHeaderEntries() + "." + this.getUnsignedEncodedPayload();
        byte[] bytesToBeSigned = StringUtils.toBytesUTF8((String)sequenceToBeSigned);
        byte[] signatureBytes = signer.sign(unionHeaders, bytesToBeSigned);
        String encodedSignatureBytes = Base64UrlUtility.encode((byte[])signatureBytes);
        JwsJsonSignatureEntry signature = new JwsJsonSignatureEntry(this.encodedPayload, protectedHeader.getEncodedHeaderEntries(), encodedSignatureBytes, unprotectedHeader);
        return this.updateJwsJsonSignedDocument(signature);
    }

    private String updateJwsJsonSignedDocument(JwsJsonSignatureEntry signature) {
        if (this.signatures.isEmpty()) {
            this.jwsJsonSignedDocBuilder.append("{\"payload\":\"" + this.encodedPayload + "\"");
            this.jwsJsonSignedDocBuilder.append(",\"signatures\":[");
        } else {
            this.jwsJsonSignedDocBuilder.append(",");
        }
        this.jwsJsonSignedDocBuilder.append(signature.toJson());
        this.signatures.add(signature);
        return this.getJwsJsonSignedDocument();
    }
}

