/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.ECPrivateKey;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public class EcdhDirectKeyJweDecryption
extends DirectKeyJweDecryption {
    public EcdhDirectKeyJweDecryption(ECPrivateKey privateKey, String supportedCtAlgo) {
        super(new EcdhDirectKeyDecryptionAlgorithm(privateKey), (ContentDecryptionAlgorithm)new AesGcmContentDecryptionAlgorithm(supportedCtAlgo));
    }

    protected static byte[] getDecryptedContentEncryptionKeyFromHeaders(JweHeaders headers, ECPrivateKey privateKey) {
        Algorithm jwtAlgo = Algorithm.valueOf(headers.getContentEncryptionAlgorithm());
        JsonWebKey publicJwk = headers.getJsonWebKey("epv");
        String apuHeader = (String)headers.getHeader("apu");
        byte[] apuBytes = apuHeader == null ? null : JoseUtils.decode(apuHeader);
        String apvHeader = (String)headers.getHeader("apv");
        byte[] apvBytes = apvHeader == null ? null : JoseUtils.decode(apvHeader);
        return JweUtils.getECDHKey(privateKey, JwkUtils.toECPublicKey(publicJwk), apuBytes, apvBytes, jwtAlgo.getJwtName(), jwtAlgo.getKeySizeBits());
    }

    protected static class EcdhDirectKeyDecryptionAlgorithm
    extends DirectKeyJweDecryption.DirectKeyDecryptionAlgorithm {
        private ECPrivateKey privateKey;

        public EcdhDirectKeyDecryptionAlgorithm(ECPrivateKey privateKey) {
            super((byte[])null);
            this.privateKey = privateKey;
        }

        @Override
        public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
            super.validateKeyEncryptionKey(jweDecryptionInput);
            return EcdhDirectKeyJweDecryption.getDecryptedContentEncryptionKeyFromHeaders(jweDecryptionInput.getJweHeaders(), this.privateKey);
        }
    }
}

