/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;

public abstract class AbstractWrapKeyEncryptionAlgorithm
implements KeyEncryptionAlgorithm {
    private Key keyEncryptionKey;
    private boolean wrap;
    private String algorithm;
    private Set<String> supportedAlgorithms;

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, Set<String> supportedAlgorithms) {
        this(key, null, true, supportedAlgorithms);
    }

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, boolean wrap, Set<String> supportedAlgorithms) {
        this(key, null, wrap, supportedAlgorithms);
    }

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, String jweAlgo, Set<String> supportedAlgorithms) {
        this(key, jweAlgo, true, supportedAlgorithms);
    }

    protected AbstractWrapKeyEncryptionAlgorithm(Key key, String jweAlgo, boolean wrap, Set<String> supportedAlgorithms) {
        this.keyEncryptionKey = key;
        this.algorithm = jweAlgo;
        this.wrap = wrap;
        this.supportedAlgorithms = supportedAlgorithms;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        this.checkAlgorithms(headers);
        KeyProperties secretKeyProperties = new KeyProperties(this.getKeyEncryptionAlgoJava(headers));
        AlgorithmParameterSpec spec = this.getAlgorithmParameterSpec(headers);
        if (spec != null) {
            secretKeyProperties.setAlgoSpec(spec);
        }
        if (!this.wrap) {
            return CryptoUtils.encryptBytes((byte[])cek, (Key)this.keyEncryptionKey, (KeyProperties)secretKeyProperties);
        }
        return CryptoUtils.wrapSecretKey((byte[])cek, (String)this.getContentEncryptionAlgoJava(headers), (Key)this.keyEncryptionKey, (KeyProperties)secretKeyProperties);
    }

    protected String getKeyEncryptionAlgoJava(JweHeaders headers) {
        return Algorithm.toJavaName(headers.getKeyEncryptionAlgorithm());
    }

    protected String getContentEncryptionAlgoJava(JweHeaders headers) {
        return Algorithm.toJavaName(headers.getContentEncryptionAlgorithm());
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweHeaders headers) {
        return null;
    }

    protected String checkAlgorithm(String algo) {
        if (algo != null && !this.supportedAlgorithms.contains(algo)) {
            throw new SecurityException();
        }
        return algo;
    }

    protected void checkAlgorithms(JweHeaders headers) {
        String providedAlgo = headers.getKeyEncryptionAlgorithm();
        if (providedAlgo == null && this.algorithm == null || providedAlgo != null && this.algorithm != null && !providedAlgo.equals(this.algorithm)) {
            throw new SecurityException();
        }
        if (providedAlgo != null) {
            this.checkAlgorithm(providedAlgo);
        } else if (this.algorithm != null) {
            headers.setKeyEncryptionAlgorithm(this.algorithm);
            this.checkAlgorithm(this.algorithm);
        }
    }
}

