/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose;

import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.provider.json.JsonMapObject;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;

public class JoseHeaders
extends JsonMapObject {
    public JoseHeaders() {
    }

    public JoseHeaders(JoseHeaders headers) {
        this(headers.asMap());
    }

    public JoseHeaders(Map<String, Object> values) {
        super(values);
    }

    public void setType(String type) {
        this.setHeader("typ", type);
    }

    public String getType() {
        return (String)this.getHeader("typ");
    }

    public void setContentType(String type) {
        this.setHeader("cty", type);
    }

    public String getContentType() {
        return (String)this.getHeader("cty");
    }

    public void setAlgorithm(String algo) {
        this.setHeader("alg", algo);
    }

    public String getAlgorithm() {
        return (String)this.getHeader("alg");
    }

    public void setKeyId(String kid) {
        this.setHeader("kid", kid);
    }

    public String getKeyId() {
        return (String)this.getHeader("kid");
    }

    public void setX509Url(String x509Url) {
        this.setHeader("x5u", x509Url);
    }

    public String getX509Url() {
        return (String)this.getHeader("x5u");
    }

    public void setX509Chain(List<String> x509Chain) {
        this.setProperty("x5c", x509Chain);
    }

    public List<String> getX509Chain() {
        return CastUtils.cast((List)((List)this.getProperty("x5c")));
    }

    public void setX509Thumbprint(String x509Thumbprint) {
        this.setHeader("x5t", x509Thumbprint);
    }

    public String getX509Thumbprint() {
        return (String)this.getHeader("x5t");
    }

    public void setX509ThumbprintSHA256(String x509Thumbprint) {
        this.setHeader("x5t#S256", x509Thumbprint);
    }

    public String getX509ThumbprintSHA256() {
        return (String)this.getHeader("x5t#S256");
    }

    public void setCritical(List<String> crit) {
        this.setHeader("crit", crit);
    }

    public List<String> getCritical() {
        return CastUtils.cast((List)((List)this.getHeader("crit")));
    }

    public void setJsonWebKey(JsonWebKey key) {
        this.setJsonWebKey("jwk", key);
    }

    public void setJsonWebKey(String headerName, JsonWebKey key) {
        this.setHeader(headerName, (Object)key);
    }

    public JsonWebKey getJsonWebKey() {
        return this.getJsonWebKey("jwk");
    }

    public JsonWebKey getJsonWebKey(String headerName) {
        Object jsonWebKey = this.getHeader(headerName);
        if (jsonWebKey == null || jsonWebKey instanceof JsonWebKey) {
            return (JsonWebKey)((Object)jsonWebKey);
        }
        Map map = CastUtils.cast((Map)((Map)jsonWebKey));
        return new JsonWebKey(map);
    }

    public JoseHeaders setHeader(String name, Object value) {
        this.setProperty(name, value);
        return this;
    }

    public Object getHeader(String name) {
        return this.getProperty(name);
    }

    public JoseHeaders setIntegerHeader(String name, Integer value) {
        this.setHeader(name, value);
        return this;
    }

    public Integer getIntegerHeader(String name) {
        return this.getIntegerProperty(name);
    }

    public JoseHeaders setLongHeader(String name, Long value) {
        this.setHeader(name, value);
        return this;
    }

    public Long getLongHeader(String name) {
        return this.getLongProperty(name);
    }
}

