/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import org.apache.cxf.rs.security.jose.jwe.AbstractJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public class DirectKeyJweDecryption
extends AbstractJweDecryption {
    public DirectKeyJweDecryption(Key contentDecryptionKey, ContentDecryptionAlgorithm cipherProps) {
        this(new DirectKeyDecryptionAlgorithm(contentDecryptionKey), cipherProps);
    }

    protected DirectKeyJweDecryption(DirectKeyDecryptionAlgorithm direct, ContentDecryptionAlgorithm cipherProps) {
        super(direct, cipherProps);
    }

    protected static class DirectKeyDecryptionAlgorithm
    implements KeyDecryptionAlgorithm {
        private byte[] contentDecryptionKey;

        public DirectKeyDecryptionAlgorithm(Key contentDecryptionKey) {
            this(contentDecryptionKey.getEncoded());
        }

        public DirectKeyDecryptionAlgorithm(byte[] contentDecryptionKey) {
            this.contentDecryptionKey = contentDecryptionKey;
        }

        @Override
        public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
            this.validateKeyEncryptionKey(jweDecryptionInput);
            return this.contentDecryptionKey;
        }

        @Override
        public String getAlgorithm() {
            return null;
        }

        protected void validateKeyEncryptionKey(JweDecryptionInput jweDecryptionInput) {
            byte[] encryptedCEK = jweDecryptionInput.getEncryptedCEK();
            if (encryptedCEK != null && encryptedCEK.length > 0) {
                throw new SecurityException();
            }
        }
    }
}

