/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionState;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonEncryptionEntry;

public class JweJsonProducer {
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();
    private JweHeaders protectedHeader;
    private JweHeaders unprotectedHeader;
    private byte[] content;
    private byte[] aad;

    public JweJsonProducer(JweHeaders protectedHeader, byte[] content) {
        this.protectedHeader = protectedHeader;
        this.content = content;
    }

    public JweJsonProducer(JweHeaders protectedHeader, byte[] content, byte[] aad) {
        this(protectedHeader, content);
        this.aad = aad;
    }

    public JweJsonProducer(JweHeaders protectedHeader, JweHeaders unprotectedHeader, byte[] content, byte[] aad) {
        this(protectedHeader, content, aad);
        this.unprotectedHeader = unprotectedHeader;
    }

    public String encryptWith(JweEncryptionProvider encryptor) {
        return this.encryptWith(Collections.singletonList(encryptor), null);
    }

    public String encryptWith(JweEncryptionProvider encryptor, JweHeaders recipientUnprotected) {
        return this.encryptWith(Collections.singletonList(encryptor), Collections.singletonList(recipientUnprotected));
    }

    public String encryptWith(List<JweEncryptionProvider> encryptors) {
        return this.encryptWith(encryptors, null);
    }

    public String encryptWith(List<JweEncryptionProvider> encryptors, List<JweHeaders> recipientUnprotected) {
        this.checkAndGetContentAlgorithm(encryptors);
        if (recipientUnprotected != null && recipientUnprotected.size() != encryptors.size()) {
            throw new IllegalArgumentException();
        }
        byte[] cek = CryptoUtils.generateSecureRandomBytes((int)32);
        byte[] iv = CryptoUtils.generateSecureRandomBytes((int)16);
        JweHeaders unionHeaders = new JweHeaders();
        if (this.protectedHeader != null) {
            unionHeaders.asMap().putAll(this.protectedHeader.asMap());
        }
        if (this.unprotectedHeader != null) {
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), this.unprotectedHeader.asMap().keySet())) {
                throw new SecurityException("Protected and unprotected headers have duplicate values");
            }
            unionHeaders.asMap().putAll(this.unprotectedHeader.asMap());
        }
        ArrayList<JweJsonEncryptionEntry> entries = new ArrayList<JweJsonEncryptionEntry>(encryptors.size());
        LinkedHashMap<String, Object> jweJsonMap = new LinkedHashMap<String, Object>();
        if (this.protectedHeader != null) {
            jweJsonMap.put("protected", Base64UrlUtility.encode((String)this.writer.toJson(this.protectedHeader)));
        }
        if (this.unprotectedHeader != null) {
            jweJsonMap.put("unprotected", (Object)this.unprotectedHeader);
        }
        byte[] cipherText = null;
        byte[] authTag = null;
        for (int i = 0; i < encryptors.size(); ++i) {
            JweEncryptionProvider encryptor = encryptors.get(i);
            JweHeaders perRecipientUnprotected = recipientUnprotected == null ? null : recipientUnprotected.get(i);
            JweHeaders jsonHeaders = null;
            if (recipientUnprotected != null) {
                if (!Collections.disjoint(unionHeaders.asMap().keySet(), perRecipientUnprotected.asMap().keySet())) {
                    throw new SecurityException("Protected and unprotected headers have duplicate values");
                }
                jsonHeaders = new JweHeaders(unionHeaders.asMap());
                jsonHeaders.asMap().putAll(this.unprotectedHeader.asMap());
            } else {
                jsonHeaders = unionHeaders;
            }
            jsonHeaders.setProtectedHeaders(this.protectedHeader);
            JweEncryptionInput input = new JweEncryptionInput(jsonHeaders, cek, iv, this.aad);
            JweEncryptionState state = encryptor.createJweEncryptionState(input);
            try {
                byte[] currentCipherOutput = state.getCipher().doFinal(this.content);
                byte[] currentCipherText = null;
                byte[] currentAuthTag = null;
                if (state.getAuthTagProducer() != null) {
                    currentCipherText = currentCipherOutput;
                    state.getAuthTagProducer().update(this.content, 0, this.content.length);
                    currentAuthTag = state.getAuthTagProducer().getTag();
                } else {
                    int authTagLengthBits = 128;
                    int cipherTextLen = currentCipherOutput.length - 16;
                    currentCipherText = Arrays.copyOf(currentCipherOutput, cipherTextLen);
                    currentAuthTag = Arrays.copyOfRange(currentCipherOutput, cipherTextLen, cipherTextLen + 16);
                    if (cipherText == null) {
                        cipherText = currentCipherText;
                    } else if (!Arrays.equals(cipherText, currentCipherText)) {
                        throw new SecurityException();
                    }
                    if (authTag == null) {
                        authTag = currentAuthTag;
                    } else if (!Arrays.equals(authTag, currentAuthTag)) {
                        throw new SecurityException();
                    }
                }
                byte[] encryptedCek = state.getContentEncryptionKey();
                if (encryptedCek == null && encryptor.getKeyAlgorithm() != null) {
                    throw new SecurityException();
                }
                String encodedCek = encryptedCek == null ? null : Base64UrlUtility.encode((byte[])encryptedCek);
                entries.add(new JweJsonEncryptionEntry(perRecipientUnprotected, encodedCek));
                continue;
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        }
        jweJsonMap.put("recipients", entries);
        if (this.aad != null) {
            jweJsonMap.put("aad", Base64UrlUtility.encode((byte[])this.aad));
        }
        jweJsonMap.put("iv", Base64UrlUtility.encode((byte[])iv));
        jweJsonMap.put("ciphertext", Base64UrlUtility.encode(cipherText));
        jweJsonMap.put("tag", Base64UrlUtility.encode(authTag));
        return this.writer.toJson(jweJsonMap);
    }

    private String checkAndGetContentAlgorithm(List<JweEncryptionProvider> encryptors) {
        HashSet<String> set = new HashSet<String>();
        for (JweEncryptionProvider encryptor : encryptors) {
            set.add(encryptor.getContentAlgorithm());
        }
        if (set.size() != 1) {
            throw new SecurityException("Invalid content encryption algorithm");
        }
        return (String)set.iterator().next();
    }
}

