/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.security.Principal;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.common.security.SimpleSecurityContext;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseException;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwt.AbstractJoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.security.SecurityContext;

@PreMatching
@Priority(value=1000)
public class JwtAuthenticationFilter
extends AbstractJoseJwtConsumer
implements ContainerRequestFilter {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwtAuthenticationFilter.class);
    private boolean jweOnly;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String[] parts;
        String auth = requestContext.getHeaderString("Authorization");
        String[] stringArray = parts = auth == null ? null : auth.split(" ");
        if (parts == null || !"JWT".equals(parts[0]) || parts.length != 2) {
            throw new JoseException("JWT scheme is expected");
        }
        JwtToken jwt = super.getJwtToken(parts[1], this.jweOnly);
        JoseUtils.setMessageContextProperty(jwt.getHeaders());
        JAXRSUtils.getCurrentMessage().put(SecurityContext.class, (Object)new SimpleSecurityContext((Principal)((Object)new JwtPrincipal(jwt))));
    }

    public void setJweOnly(boolean jweOnly) {
        this.jweOnly = jweOnly;
    }

    public static class JwtPrincipal
    extends SimplePrincipal {
        private JwtToken jwt;

        public JwtPrincipal(JwtToken jwt) {
            super(jwt.getClaims().getSubject());
            this.jwt = jwt;
        }

        public JwtToken getJwt() {
            return this.jwt;
        }
    }
}

