/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.JoseException;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsReaderProvider;
import org.apache.cxf.rs.security.jose.jaxrs.JwtTokenSecurityContext;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.security.SecurityContext;

@PreMatching
@Priority(value=1002)
public class JwtJwsAuthenticationFilter
extends AbstractJwsReaderProvider
implements ContainerRequestFilter {
    private static final String JWS_CONTEXT_PROPERTY = "org.apache.cxf.jws.context";
    private static final String JWT_SCHEME_PROPERTY = "JWT";

    public void filter(ContainerRequestContext context) throws IOException {
        String authHeader = context.getHeaderString("Authorization");
        String[] schemeData = authHeader.split(" ");
        if (schemeData.length != 2 || !JWT_SCHEME_PROPERTY.equals(schemeData[0])) {
            throw new JoseException("JWT scheme is expected");
        }
        JwsJwtCompactConsumer p = new JwsJwtCompactConsumer(schemeData[1]);
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier(p.getJoseHeaders());
        if (!p.verifySignatureWith(theSigVerifier)) {
            context.abortWith(JAXRSUtils.toResponse((int)400));
            return;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        this.setRequestContextProperty(m, p);
        JwtToken token = p.getJwtToken();
        m.put(SecurityContext.class, (Object)new JwtTokenSecurityContext(token));
    }

    protected void setRequestContextProperty(Message m, JwsCompactConsumer c) {
        Object headerContext = c.getJoseHeaders().getHeader(JWS_CONTEXT_PROPERTY);
        if (headerContext != null) {
            m.put((Object)JWS_CONTEXT_PROPERTY, headerContext);
        }
    }
}

