/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.ByteBuffer;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public class AesCbcHmacJweEncryption
extends JweEncryption {
    private static final Map<String, String> AES_HMAC_MAP = new HashMap<String, String>();
    private static final Map<String, Integer> AES_CEK_SIZE_MAP;

    public AesCbcHmacJweEncryption(String cekAlgo, KeyEncryptionProvider keyEncryptionAlgorithm) {
        this(ContentAlgorithm.getAlgorithm(cekAlgo), keyEncryptionAlgorithm);
    }

    public AesCbcHmacJweEncryption(ContentAlgorithm cekAlgoJwt, KeyEncryptionProvider keyEncryptionAlgorithm) {
        this(cekAlgoJwt, null, null, keyEncryptionAlgorithm);
    }

    public AesCbcHmacJweEncryption(ContentAlgorithm cekAlgoJwt, byte[] cek, byte[] iv, KeyEncryptionProvider keyEncryptionAlgorithm) {
        super(keyEncryptionAlgorithm, new AesCbcContentEncryptionAlgorithm(cek, iv, AesCbcHmacJweEncryption.validateCekAlgorithm(cekAlgoJwt)));
    }

    @Override
    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return AesCbcHmacJweEncryption.doGetActualCek(theCek, algoJwt);
    }

    @Override
    protected int getCekSize(String algoJwt) {
        return AesCbcHmacJweEncryption.getFullCekKeySize(algoJwt) * 8;
    }

    protected static byte[] doGetActualCek(byte[] theCek, String algoJwt) {
        int size = AesCbcHmacJweEncryption.getFullCekKeySize(algoJwt) / 2;
        byte[] actualCek = new byte[size];
        System.arraycopy(theCek, size, actualCek, 0, size);
        return actualCek;
    }

    protected static int getFullCekKeySize(String algoJwt) {
        return AES_CEK_SIZE_MAP.get(algoJwt);
    }

    @Override
    protected byte[] getActualCipher(byte[] cipher) {
        return cipher;
    }

    @Override
    protected byte[] getAuthenticationTag(AbstractJweEncryption.JweEncryptionInternal state, byte[] cipher) {
        MacState macState = this.getInitializedMacState(state);
        macState.mac.update(cipher);
        return AesCbcHmacJweEncryption.signAndGetTag(macState);
    }

    protected static byte[] signAndGetTag(MacState macState) {
        macState.mac.update(macState.al);
        byte[] sig = macState.mac.doFinal();
        int authTagLen = 16;
        byte[] authTag = new byte[authTagLen];
        System.arraycopy(sig, 0, authTag, 0, authTagLen);
        return authTag;
    }

    private MacState getInitializedMacState(AbstractJweEncryption.JweEncryptionInternal state) {
        return AesCbcHmacJweEncryption.getInitializedMacState(state.secretKey, state.theIv, state.aad, state.theHeaders, state.protectedHeadersJson);
    }

    protected static MacState getInitializedMacState(byte[] secretKey, byte[] theIv, byte[] extraAad, JweHeaders theHeaders, String protectedHeadersJson) {
        String algoJwt = theHeaders.getContentEncryptionAlgorithm();
        int size = AesCbcHmacJweEncryption.getFullCekKeySize(algoJwt) / 2;
        byte[] macKey = new byte[size];
        System.arraycopy(secretKey, 0, macKey, 0, size);
        String hmacAlgoJava = AES_HMAC_MAP.get(algoJwt);
        Mac mac = HmacUtils.getInitializedMac((byte[])macKey, (String)hmacAlgoJava, null);
        byte[] aad = JweUtils.getAdditionalAuthenticationData(protectedHeadersJson, extraAad);
        ByteBuffer buf = ByteBuffer.allocate(8);
        byte[] al = buf.putInt(0).putInt(aad.length * 8).array();
        mac.update(aad);
        mac.update(theIv);
        MacState macState = new MacState();
        macState.mac = mac;
        MacState.access$002(macState, al);
        return macState;
    }

    @Override
    protected AuthenticationTagProducer getAuthenticationTagProducer(AbstractJweEncryption.JweEncryptionInternal state) {
        final MacState macState = this.getInitializedMacState(state);
        return new AuthenticationTagProducer(){

            @Override
            public void update(byte[] cipher, int off, int len) {
                macState.mac.update(cipher, off, len);
            }

            @Override
            public byte[] getTag() {
                return AesCbcHmacJweEncryption.signAndGetTag(macState);
            }
        };
    }

    @Override
    protected byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] theCek) {
        return this.getKeyEncryptionAlgo().getEncryptedContentEncryptionKey(headers, theCek);
    }

    private static ContentAlgorithm validateCekAlgorithm(ContentAlgorithm cekAlgo) {
        if (!AlgorithmUtils.isAesCbcHmac(cekAlgo.getJwaName())) {
            LOG.warning("Invalid content encryption algorithm");
            throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
        }
        return cekAlgo;
    }

    static {
        AES_HMAC_MAP.put(ContentAlgorithm.A128CBC_HS256.getJwaName(), "HmacSHA256");
        AES_HMAC_MAP.put(ContentAlgorithm.A192CBC_HS384.getJwaName(), "HmacSHA384");
        AES_HMAC_MAP.put(ContentAlgorithm.A256CBC_HS512.getJwaName(), "HmacSHA512");
        AES_CEK_SIZE_MAP = new HashMap<String, Integer>();
        AES_CEK_SIZE_MAP.put(ContentAlgorithm.A128CBC_HS256.getJwaName(), 32);
        AES_CEK_SIZE_MAP.put(ContentAlgorithm.A192CBC_HS384.getJwaName(), 48);
        AES_CEK_SIZE_MAP.put(ContentAlgorithm.A256CBC_HS512.getJwaName(), 64);
    }

    protected static class MacState {
        protected Mac mac;
        private byte[] al;

        protected MacState() {
        }

        static /* synthetic */ byte[] access$002(MacState x0, byte[] x1) {
            x0.al = x1;
            return x1;
        }
    }

    private static class AesCbcContentEncryptionAlgorithm
    extends AbstractContentEncryptionAlgorithm {
        public AesCbcContentEncryptionAlgorithm(byte[] cek, byte[] iv, ContentAlgorithm algo) {
            super(cek, iv, algo);
        }

        @Override
        public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
            return new IvParameterSpec(theIv);
        }

        @Override
        public byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
            return null;
        }
    }
}

