/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

public abstract class AbstractJwsSignatureProvider
implements JwsSignatureProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJwsSignatureProvider.class);
    private SignatureAlgorithm algorithm;

    protected AbstractJwsSignatureProvider(SignatureAlgorithm algo) {
        this.algorithm = algo;
    }

    protected JwsHeaders prepareHeaders(JwsHeaders headers) {
        String algo;
        if (headers == null) {
            headers = new JwsHeaders();
        }
        if ((algo = headers.getAlgorithm()) != null) {
            this.checkAlgorithm(algo);
        } else {
            this.checkAlgorithm(this.algorithm.getJwaName());
            headers.setAlgorithm(this.algorithm.getJwaName());
        }
        return headers;
    }

    @Override
    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] sign(JwsHeaders headers, byte[] content) {
        JwsSignature sig = this.createJwsSignature(headers);
        sig.update(content, 0, content.length);
        return sig.sign();
    }

    @Override
    public JwsSignature createJwsSignature(JwsHeaders headers) {
        return this.doCreateJwsSignature(this.prepareHeaders(headers));
    }

    protected abstract JwsSignature doCreateJwsSignature(JoseHeaders var1);

    protected void checkAlgorithm(String algo) {
        if (algo == null) {
            LOG.warning("Signature algorithm is not set");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (!this.isValidAlgorithmFamily(algo)) {
            LOG.warning("Invalid signature algorithm: " + algo);
            throw new JwsException(JwsException.Error.INVALID_ALGORITHM);
        }
    }

    protected abstract boolean isValidAlgorithmFamily(String var1);
}

