/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.provider.json.JsonMapObject;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonConsumer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsJsonConsumer.class);
    private String jwsSignedDocument;
    private String encodedJwsPayload;
    private List<JwsJsonSignatureEntry> signatureEntries = new LinkedList<JwsJsonSignatureEntry>();

    public JwsJsonConsumer(String jwsSignedDocument) {
        this(jwsSignedDocument, null);
    }

    public JwsJsonConsumer(String jwsSignedDocument, String encodedDetachedPayload) {
        this.jwsSignedDocument = jwsSignedDocument;
        this.prepare(encodedDetachedPayload);
    }

    private void prepare(String encodedDetachedPayload) {
        JsonMapObject jsonObject = new JsonMapObject();
        new JsonMapObjectReaderWriter().fromJson(jsonObject, this.jwsSignedDocument);
        Map jsonObjectMap = jsonObject.asMap();
        this.encodedJwsPayload = (String)jsonObjectMap.get("payload");
        if (this.encodedJwsPayload == null) {
            this.encodedJwsPayload = encodedDetachedPayload;
        } else if (encodedDetachedPayload != null) {
            LOG.warning("JSON JWS includes a payload expected to be detached");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        if (this.encodedJwsPayload == null) {
            LOG.warning("JSON JWS has no payload");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        List signatureArray = CastUtils.cast((List)((List)jsonObjectMap.get("signatures")));
        if (signatureArray != null) {
            if (jsonObjectMap.containsKey("signature")) {
                LOG.warning("JSON JWS has a flattened 'signature' element and a 'signatures' object");
                throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
            }
            for (Map signatureEntry : signatureArray) {
                this.signatureEntries.add(this.getSignatureObject(signatureEntry));
            }
        } else {
            this.signatureEntries.add(this.getSignatureObject(jsonObjectMap));
        }
        if (this.signatureEntries.isEmpty()) {
            LOG.warning("JSON JWS has no signatures");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
    }

    protected JwsJsonSignatureEntry getSignatureObject(Map<String, Object> signatureEntry) {
        String protectedHeader = (String)signatureEntry.get("protected");
        Map header = CastUtils.cast((Map)((Map)signatureEntry.get("header")));
        String signature = (String)signatureEntry.get("signature");
        return new JwsJsonSignatureEntry(this.encodedJwsPayload, protectedHeader, signature, header != null ? new JoseHeaders(header) : null);
    }

    public String getSignedDocument() {
        return this.jwsSignedDocument;
    }

    public String getEncodedJwsPayload() {
        return this.encodedJwsPayload;
    }

    public String getDecodedJwsPayload() {
        return JoseUtils.decodeToString(this.encodedJwsPayload);
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.getDecodedJwsPayload());
    }

    public List<JwsJsonSignatureEntry> getSignatureEntries() {
        return Collections.unmodifiableList(this.signatureEntries);
    }

    public MultivaluedMap<String, JwsJsonSignatureEntry> getSignatureEntryMap() {
        return JwsUtils.getJwsJsonSignatureMap(this.signatureEntries);
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        List theSignatureEntries = (List)this.getSignatureEntryMap().get((Object)validator.getAlgorithm().getJwaName());
        if (theSignatureEntries != null) {
            for (JwsJsonSignatureEntry signatureEntry : theSignatureEntries) {
                if (!signatureEntry.verifySignatureWith(validator)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verifySignatureWith(PublicKey key, String algo) {
        return this.verifySignatureWith(JwsUtils.getPublicKeySignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(byte[] key, String algo) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(List<JwsSignatureVerifier> validators) {
        try {
            if (this.verifyAndGetNonValidated(validators).isEmpty()) {
                return true;
            }
        }
        catch (JwsException jwsException) {
            // empty catch block
        }
        LOG.warning("One of JSON JWS signatures is invalid");
        return false;
    }

    public List<JwsJsonSignatureEntry> verifyAndGetNonValidated(List<JwsSignatureVerifier> validators) {
        LinkedList<JwsJsonSignatureEntry> validatedSignatures = new LinkedList<JwsJsonSignatureEntry>();
        block0: for (JwsSignatureVerifier validator : validators) {
            List theSignatureEntries = (List)this.getSignatureEntryMap().get((Object)validator.getAlgorithm().getJwaName());
            if (theSignatureEntries == null) continue;
            for (JwsJsonSignatureEntry sigEntry : theSignatureEntries) {
                if (!sigEntry.verifySignatureWith(validator)) continue;
                validatedSignatures.add(sigEntry);
                continue block0;
            }
        }
        LinkedList<JwsJsonSignatureEntry> nonValidatedSignatures = new LinkedList<JwsJsonSignatureEntry>();
        for (JwsJsonSignatureEntry sigEntry : this.signatureEntries) {
            if (validatedSignatures.contains(sigEntry)) continue;
            nonValidatedSignatures.add(sigEntry);
        }
        return nonValidatedSignatures;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean verifySignatureWith(JsonWebKey key, String algo) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key, algo));
    }

    public JwsJsonProducer toProducer() {
        JwsJsonProducer p = new JwsJsonProducer(this.getDecodedJwsPayload());
        p.getSignatureEntries().addAll(this.signatureEntries);
        return p;
    }
}

