/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseException;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwt.AbstractJoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@Priority(value=1000)
public class JwtAuthenticationClientFilter
extends AbstractJoseJwtProducer
implements ClientRequestFilter {
    public void filter(ClientRequestContext requestContext) throws IOException {
        AuthorizationPolicy ap;
        JwtToken jwt = this.getJwtToken(requestContext);
        boolean jweRequired = false;
        if (jwt == null && (ap = (AuthorizationPolicy)((Endpoint)JAXRSUtils.getCurrentMessage().getExchange().get(Endpoint.class)).getEndpointInfo().getExtensor(AuthorizationPolicy.class)) != null && ap.getUserName() != null) {
            JwtClaims claims = new JwtClaims();
            claims.setSubject(ap.getUserName());
            claims.setClaim("password", ap.getPassword());
            claims.setIssuedAt(System.currentTimeMillis() / 1000L);
            jwt = new JwtToken(new JweHeaders(), claims);
            jweRequired = true;
        }
        if (jwt == null) {
            throw new JoseException("JWT token is not available");
        }
        JoseUtils.setJoseMessageContextProperty(jwt.getHeaders(), this.getContextPropertyValue());
        String data = super.processJwt(jwt, true, jweRequired);
        requestContext.getHeaders().putSingle((Object)"Authorization", (Object)("JWT " + data));
    }

    protected JwtToken getJwtToken(ClientRequestContext requestContext) {
        return (JwtToken)requestContext.getProperty("jwt.token");
    }

    protected String getContextPropertyValue() {
        return Base64UrlUtility.encode((byte[])CryptoUtils.generateSecureRandomBytes((int)16));
    }
}

