/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.common.AbstractJoseProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;

public abstract class AbstractJoseJwtProducer
extends AbstractJoseProducer {
    private boolean jwsRequired = true;
    private boolean jweRequired;

    protected String processJwt(JwtToken jwt) {
        return this.processJwt(jwt, null, null);
    }

    protected String processJwt(JwtToken jwt, JweEncryptionProvider theEncProvider, JwsSignatureProvider theSigProvider) {
        if (!this.isJwsRequired() && !this.isJweRequired()) {
            throw new JwtException("Unable to secure JWT");
        }
        String data = null;
        if (this.isJweRequired() && theEncProvider == null && (theEncProvider = this.getInitializedEncryptionProvider()) == null) {
            throw new JwtException("Unable to encrypt JWT");
        }
        if (this.isJwsRequired()) {
            JwsJwtCompactProducer jws = new JwsJwtCompactProducer(jwt);
            if (jws.isPlainText()) {
                data = jws.getSignedEncodedJws();
            } else {
                if (theSigProvider == null) {
                    theSigProvider = this.getInitializedSignatureProvider();
                }
                if (theSigProvider == null) {
                    throw new JwtException("Unable to sign JWT");
                }
                data = jws.signWith(theSigProvider);
            }
            if (theEncProvider != null) {
                data = theEncProvider.encrypt(StringUtils.toBytesUTF8((String)data), null);
            }
        } else {
            JweJwtCompactProducer jwe = new JweJwtCompactProducer(jwt);
            data = jwe.encryptWith(theEncProvider);
        }
        return data;
    }

    public boolean isJwsRequired() {
        return this.jwsRequired;
    }

    public void setJwsRequired(boolean jwsRequired) {
        this.jwsRequired = jwsRequired;
    }

    public boolean isJweRequired() {
        return this.jweRequired;
    }

    public void setJweRequired(boolean jweRequired) {
        this.jweRequired = jweRequired;
    }
}

