/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public abstract class AbstractJoseConsumer {
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public JweDecryptionProvider getJweDecryptor() {
        return this.jweDecryptor;
    }

    public void setJwsVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    public JwsSignatureVerifier getJwsVerifier() {
        return this.jwsVerifier;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(JweHeaders jweHeaders) {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider(jweHeaders, false);
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwsHeaders jwsHeaders) {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        return JwsUtils.loadSignatureVerifier(jwsHeaders, false);
    }
}

