/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.Base64UrlOutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsJsonWriterProvider;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonOutputStream;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

@Priority(value=1002)
public class JwsJsonWriterInterceptor
extends AbstractJwsJsonWriterProvider
implements WriterInterceptor {
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();
    private boolean contentTypeRequired = true;
    private boolean useJwsOutputStream;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        List<JwsSignatureProvider> sigProviders = this.getInitializedSigProviders();
        OutputStream actualOs = ctx.getOutputStream();
        if (this.useJwsOutputStream) {
            ArrayList<String> protectedHeaders = new ArrayList<String>(sigProviders.size());
            ArrayList<JwsSignature> signatures = new ArrayList<JwsSignature>(sigProviders.size());
            for (JwsSignatureProvider signer : sigProviders) {
                JwsHeaders protectedHeader = this.prepareProtectedHeader(ctx, signer);
                String encoded = Base64UrlUtility.encode((String)this.writer.toJson(protectedHeader));
                protectedHeaders.add(encoded);
                JwsSignature signature = signer.createJwsSignature(protectedHeader);
                byte[] start = StringUtils.toBytesUTF8((String)(encoded + "."));
                signature.update(start, 0, start.length);
                signatures.add(signature);
            }
            ctx.setMediaType(JAXRSUtils.toMediaType((String)"application/jose+json"));
            actualOs.write(StringUtils.toBytesUTF8((String)"{\"payload\":\""));
            JwsJsonOutputStream jwsStream = new JwsJsonOutputStream(actualOs, protectedHeaders, signatures);
            Base64UrlOutputStream base64Stream = new Base64UrlOutputStream((OutputStream)jwsStream);
            ctx.setOutputStream((OutputStream)base64Stream);
            ctx.proceed();
            base64Stream.flush();
            jwsStream.flush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            JwsJsonProducer p = new JwsJsonProducer(new String(cos.getBytes(), "UTF-8"));
            for (JwsSignatureProvider signer : sigProviders) {
                JwsHeaders protectedHeader = this.prepareProtectedHeader(ctx, signer);
                p.signWith(signer, protectedHeader, null);
            }
            ctx.setMediaType(JAXRSUtils.toMediaType((String)"application/jose+json"));
            this.writeJws(p, actualOs);
        }
    }

    private JwsHeaders prepareProtectedHeader(WriterInterceptorContext ctx, JwsSignatureProvider signer) {
        JwsHeaders headers = new JwsHeaders();
        headers.setAlgorithm(signer.getAlgorithm().getJwaName());
        this.setContentTypeIfNeeded(headers, ctx);
        return headers;
    }

    public void setContentTypeRequired(boolean contentTypeRequired) {
        this.contentTypeRequired = contentTypeRequired;
    }

    public void setUseJwsJsonOutputStream(boolean useJwsJsonOutputStream) {
        this.useJwsOutputStream = useJwsJsonOutputStream;
    }

    private void setContentTypeIfNeeded(JoseHeaders headers, WriterInterceptorContext ctx) {
        MediaType mt;
        if (this.contentTypeRequired && (mt = ctx.getMediaType()) != null && !JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]).equals("application/jose+json")) {
            if ("application".equals(mt.getType())) {
                headers.setContentType(mt.getSubtype());
            } else {
                headers.setContentType(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]));
            }
        }
    }
}

