/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwa;

import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;

public enum SignatureAlgorithm {
    HS256("HS256", "HmacSHA256", 256),
    HS384("HS384", "HmacSHA384", 384),
    HS512("HS512", "HmacSHA512", 512),
    RS256("RS256", "SHA256withRSA", 256),
    RS384("RS384", "SHA384withRSA", 384),
    RS512("RS512", "SHA512withRSA", 512),
    PS256("PS256", "SHA256withRSAandMGF1", 256),
    PS384("PS384", "SHA384withRSAandMGF1", 384),
    PS512("PS512", "SHA512withRSAandMGF1", 512),
    ES256("ES256", "SHA256withECDSA", 256),
    ES384("ES384", "SHA384withECDSA", 384),
    ES512("ES512", "SHA512withECDSA", 512),
    PLAIN("none", null, -1);

    private final String jwaName;
    private final String javaName;
    private final int keySizeBits;

    private SignatureAlgorithm(String jwaName, String javaName, int keySizeBits) {
        this.jwaName = jwaName;
        this.javaName = javaName;
        this.keySizeBits = keySizeBits;
    }

    public String getJwaName() {
        return this.jwaName;
    }

    public String getJavaName() {
        return this.javaName == null ? this.name() : this.javaName;
    }

    public String getJavaAlgoName() {
        return AlgorithmUtils.stripAlgoProperties(this.getJavaName());
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public static SignatureAlgorithm getAlgorithm(String algo) {
        return SignatureAlgorithm.valueOf(algo.replace('-', '_').replace('+', '_'));
    }
}

