/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public class EcDsaJwsSignatureVerifier
extends PublicKeyJwsSignatureVerifier {
    static final Map<String, Integer> SIGNATURE_LENGTH_MAP = new HashMap<String, Integer>();

    public EcDsaJwsSignatureVerifier(PublicKey key, SignatureAlgorithm supportedAlgo) {
        this(key, null, supportedAlgo);
    }

    public EcDsaJwsSignatureVerifier(PublicKey key, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        super(key, spec, supportedAlgo);
    }

    @Override
    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        String algoName = super.getAlgorithm().getJwaName();
        if (SIGNATURE_LENGTH_MAP.get(algoName) != signature.length) {
            LOG.warning("Algorithm " + algoName + " signature length is " + SIGNATURE_LENGTH_MAP.get(algoName) + ", actual length is " + signature.length);
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
        byte[] der = EcDsaJwsSignatureVerifier.signatureToDer(signature);
        return super.verify(headers, unsignedText, der);
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return AlgorithmUtils.isEcDsaSign(algo);
    }

    private static byte[] signatureToDer(byte[] joseSig) {
        int partLen = joseSig.length / 2;
        int rOffset = joseSig[0] < 0 ? 1 : 0;
        int sOffset = joseSig[partLen] < 0 ? 1 : 0;
        int rPartLen = partLen + rOffset;
        int sPartLen = partLen + sOffset;
        int totalLenBytesCount = joseSig.length > 127 ? 2 : 1;
        int rPartStart = 1 + totalLenBytesCount + 2;
        byte[] der = new byte[rPartStart + 2 + rPartLen + sPartLen];
        der[0] = 48;
        if (totalLenBytesCount == 2) {
            der[1] = -127;
        }
        der[totalLenBytesCount] = (byte)(der.length - (1 + totalLenBytesCount));
        der[totalLenBytesCount + 1] = 2;
        der[totalLenBytesCount + 2] = (byte)rPartLen;
        int sPartStart = rPartStart + rPartLen;
        der[sPartStart] = 2;
        der[sPartStart + 1] = (byte)sPartLen;
        System.arraycopy(joseSig, 0, der, rPartStart + rOffset, partLen);
        System.arraycopy(joseSig, partLen, der, sPartStart + 2 + sOffset, partLen);
        return der;
    }

    static {
        SIGNATURE_LENGTH_MAP.put(SignatureAlgorithm.ES256.getJwaName(), 64);
        SIGNATURE_LENGTH_MAP.put(SignatureAlgorithm.ES384.getJwaName(), 96);
        SIGNATURE_LENGTH_MAP.put(SignatureAlgorithm.ES512.getJwaName(), 132);
    }
}

