/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public class HmacJwsSignatureVerifier
implements JwsSignatureVerifier {
    protected static final Logger LOG = LogUtils.getL7dLogger(HmacJwsSignatureVerifier.class);
    private byte[] key;
    private AlgorithmParameterSpec hmacSpec;
    private SignatureAlgorithm supportedAlgo;

    public HmacJwsSignatureVerifier(String encodedKey) {
        this(JoseUtils.decode(encodedKey), SignatureAlgorithm.HS256);
    }

    public HmacJwsSignatureVerifier(String encodedKey, SignatureAlgorithm supportedAlgo) {
        this(JoseUtils.decode(encodedKey), supportedAlgo);
    }

    public HmacJwsSignatureVerifier(byte[] key, SignatureAlgorithm supportedAlgo) {
        this(key, null, supportedAlgo);
    }

    public HmacJwsSignatureVerifier(byte[] key, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        this.key = key;
        this.hmacSpec = spec;
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        byte[] expected = this.computeMac(headers, unsignedText);
        return Arrays.equals(expected, signature);
    }

    private byte[] computeMac(JwsHeaders headers, String text) {
        return HmacUtils.computeHmac((byte[])this.key, (String)AlgorithmUtils.toJavaName(this.checkAlgorithm(headers.getAlgorithm())), (AlgorithmParameterSpec)this.hmacSpec, (String)text);
    }

    protected String checkAlgorithm(String algo) {
        if (algo == null) {
            LOG.warning("Signature algorithm is not set");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (!AlgorithmUtils.isHmacSign(algo) || !algo.equals(this.supportedAlgo.getJwaName())) {
            LOG.warning("Invalid signature algorithm: " + algo);
            throw new JwsException(JwsException.Error.INVALID_ALGORITHM);
        }
        return algo;
    }

    @Override
    public SignatureAlgorithm getAlgorithm() {
        return this.supportedAlgo;
    }
}

