/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonProducer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsJsonProducer.class);
    private boolean supportFlattened;
    private String plainPayload;
    private String encodedPayload;
    private List<JwsJsonSignatureEntry> signatures = new LinkedList<JwsJsonSignatureEntry>();
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();

    public JwsJsonProducer(String tbsDocument) {
        this(tbsDocument, false);
    }

    public JwsJsonProducer(String tbsDocument, boolean supportFlattened) {
        this.supportFlattened = supportFlattened;
        this.plainPayload = tbsDocument;
        this.encodedPayload = Base64UrlUtility.encode((String)tbsDocument);
    }

    public String getPlainPayload() {
        return this.plainPayload;
    }

    public String getUnsignedEncodedPayload() {
        return this.encodedPayload;
    }

    public String getJwsJsonSignedDocument() {
        return this.getJwsJsonSignedDocument(false);
    }

    public String getJwsJsonSignedDocument(boolean detached) {
        if (this.signatures.isEmpty()) {
            LOG.warning("Signature is not available");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (!detached) {
            sb.append("\"payload\":\"" + this.encodedPayload + "\"");
            sb.append(",");
        }
        if (!this.supportFlattened || this.signatures.size() > 1) {
            sb.append("\"signatures\":[");
            for (int i = 0; i < this.signatures.size(); ++i) {
                JwsJsonSignatureEntry signature = this.signatures.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(signature.toJson());
            }
            sb.append("]");
        } else {
            sb.append(this.signatures.get(0).toJson(true));
        }
        sb.append("}");
        return sb.toString();
    }

    public List<JwsJsonSignatureEntry> getSignatureEntries() {
        return this.signatures;
    }

    public MultivaluedMap<String, JwsJsonSignatureEntry> getSignatureEntryMap() {
        return JwsUtils.getJwsJsonSignatureMap(this.signatures);
    }

    public String signWith(List<JwsSignatureProvider> signers) {
        for (JwsSignatureProvider signer : signers) {
            this.signWith(signer);
        }
        return this.getJwsJsonSignedDocument();
    }

    public String signWith(JwsSignatureProvider signer) {
        JoseHeaders headers = new JoseHeaders();
        headers.setAlgorithm(signer.getAlgorithm().getJwaName());
        return this.signWith(signer, headers);
    }

    public String signWith(JwsSignatureProvider signer, JoseHeaders protectedHeader) {
        return this.signWith(signer, protectedHeader, null);
    }

    public String signWith(JsonWebKey jwk) {
        return this.signWith(JwsUtils.getSignatureProvider(jwk));
    }

    public String signWith(PrivateKey key, String algo) {
        return this.signWith(JwsUtils.getPrivateKeySignatureProvider(key, algo));
    }

    public String signWith(byte[] key, String algo) {
        return this.signWith(JwsUtils.getHmacSignatureProvider(key, algo));
    }

    public String signWith(JwsSignatureProvider signer, JoseHeaders protectedHeader, JoseHeaders unprotectedHeader) {
        JwsHeaders unionHeaders = new JwsHeaders();
        if (protectedHeader != null) {
            unionHeaders.asMap().putAll(protectedHeader.asMap());
        }
        if (unprotectedHeader != null) {
            JwsJsonProducer.checkCriticalHeaders(unprotectedHeader);
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), unprotectedHeader.asMap().keySet())) {
                LOG.warning("Protected and unprotected headers have duplicate values");
                throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
            }
            unionHeaders.asMap().putAll(unprotectedHeader.asMap());
        }
        if (unionHeaders.getAlgorithm() == null) {
            LOG.warning("Algorithm header is not set");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        String sequenceToBeSigned = protectedHeader != null ? Base64UrlUtility.encode((String)this.writer.toJson(protectedHeader)) + "." + this.getUnsignedEncodedPayload() : "." + this.getUnsignedEncodedPayload();
        byte[] bytesToBeSigned = StringUtils.toBytesUTF8((String)sequenceToBeSigned);
        byte[] signatureBytes = signer.sign(unionHeaders, bytesToBeSigned);
        String encodedSignatureBytes = Base64UrlUtility.encode((byte[])signatureBytes);
        JwsJsonSignatureEntry signature = protectedHeader != null ? new JwsJsonSignatureEntry(this.encodedPayload, Base64UrlUtility.encode((String)this.writer.toJson(protectedHeader)), encodedSignatureBytes, unprotectedHeader) : new JwsJsonSignatureEntry(this.encodedPayload, null, encodedSignatureBytes, unprotectedHeader);
        return this.updateJwsJsonSignedDocument(signature);
    }

    private String updateJwsJsonSignedDocument(JwsJsonSignatureEntry signature) {
        this.signatures.add(signature);
        return this.getJwsJsonSignedDocument();
    }

    private static void checkCriticalHeaders(JoseHeaders unprotected) {
        if (unprotected.asMap().containsKey("crit")) {
            LOG.warning("Unprotected headers contain critical headers");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
    }
}

