/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.util.Collections;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonSignatureEntry {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsJsonSignatureEntry.class);
    private String encodedJwsPayload;
    private String encodedProtectedHeader;
    private String encodedSignature;
    private JoseHeaders protectedHeader;
    private JoseHeaders unprotectedHeader;
    private JwsHeaders unionHeaders;
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();

    public JwsJsonSignatureEntry(String encodedJwsPayload, String encodedProtectedHeader, String encodedSignature, JoseHeaders unprotectedHeader) {
        if (encodedProtectedHeader == null && unprotectedHeader == null || encodedSignature == null) {
            LOG.warning("Invalid Signature entry");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        this.encodedJwsPayload = encodedJwsPayload;
        this.encodedProtectedHeader = encodedProtectedHeader;
        this.encodedSignature = encodedSignature;
        this.unprotectedHeader = unprotectedHeader;
        if (encodedProtectedHeader != null) {
            this.protectedHeader = this.writer.fromJsonHeaders(JoseUtils.decodeToString(encodedProtectedHeader));
        }
        this.prepare();
    }

    private void prepare() {
        this.unionHeaders = new JwsHeaders();
        if (this.protectedHeader != null) {
            this.unionHeaders.asMap().putAll(this.protectedHeader.asMap());
        }
        if (this.unprotectedHeader != null) {
            if (!Collections.disjoint(this.unionHeaders.asMap().keySet(), this.unprotectedHeader.asMap().keySet())) {
                LOG.warning("Protected and unprotected headers have duplicate values");
                throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
            }
            this.unionHeaders.asMap().putAll(this.unprotectedHeader.asMap());
        }
    }

    public String getEncodedJwsPayload() {
        return this.encodedJwsPayload;
    }

    public String getDecodedJwsPayload() {
        return JoseUtils.decodeToString(this.encodedJwsPayload);
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.getDecodedJwsPayload());
    }

    public String getEncodedProtectedHeader() {
        return this.encodedProtectedHeader;
    }

    public JoseHeaders getProtectedHeader() {
        return this.protectedHeader;
    }

    public JoseHeaders getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    public JwsHeaders getUnionHeader() {
        return this.unionHeaders;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public byte[] getDecodedSignature() {
        return JoseUtils.decode(this.getEncodedSignature());
    }

    public String getUnsignedEncodedSequence() {
        if (this.getEncodedProtectedHeader() != null) {
            return this.getEncodedProtectedHeader() + "." + this.getEncodedJwsPayload();
        }
        return "." + this.getEncodedJwsPayload();
    }

    public String getKeyId() {
        return this.getUnionHeader().getKeyId();
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getUnionHeader(), this.getUnsignedEncodedSequence(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (JwsException jwsException) {
            // empty catch block
        }
        LOG.warning("Invalid Signature Entry");
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean validateCriticalHeaders() {
        if (this.getUnprotectedHeader().getHeader("crit") != null) {
            return false;
        }
        return JwsUtils.validateCriticalHeaders(this.getUnionHeader());
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean flattenedMode) {
        StringBuilder sb = new StringBuilder();
        if (!flattenedMode) {
            sb.append("{");
        }
        if (this.protectedHeader != null) {
            sb.append("\"protected\":\"" + Base64UrlUtility.encode((String)this.writer.toJson(this.protectedHeader)) + "\"");
        }
        if (this.unprotectedHeader != null) {
            if (this.protectedHeader != null) {
                sb.append(",");
            }
            sb.append("\"header\":" + this.writer.toJson(this.unprotectedHeader));
        }
        sb.append(",");
        sb.append("\"signature\":\"" + this.encodedSignature + "\"");
        if (!flattenedMode) {
            sb.append("}");
        }
        return sb.toString();
    }
}

