/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public final class JwsUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JwsUtils.class);
    private static final String JSON_WEB_SIGNATURE_ALGO_PROP = "rs.security.jws.content.signature.algorithm";
    private static final String RSSEC_SIGNATURE_OUT_PROPS = "rs.security.signature.out.properties";
    private static final String RSSEC_SIGNATURE_IN_PROPS = "rs.security.signature.in.properties";
    private static final String RSSEC_SIGNATURE_PROPS = "rs.security.signature.properties";
    private static final String JSON_WEB_SIGNATURE_REPORT_KEY_PROP = "rs.security.jws.report.public.key";

    private JwsUtils() {
    }

    public static String sign(PrivateKey key, String algo, String content) {
        return JwsUtils.sign(key, algo, content, null);
    }

    public static String sign(PrivateKey key, String algo, String content, String ct) {
        return JwsUtils.sign(JwsUtils.getPrivateKeySignatureProvider(key, algo), content, ct);
    }

    public static String sign(byte[] key, String algo, String content) {
        return JwsUtils.sign(key, algo, content, null);
    }

    public static String sign(byte[] key, String algo, String content, String ct) {
        return JwsUtils.sign(JwsUtils.getHmacSignatureProvider(key, algo), content, ct);
    }

    public static String verify(PublicKey key, String algo, String content) {
        JwsCompactConsumer jws = JwsUtils.verify(JwsUtils.getPublicKeySignatureVerifier(key, algo), content);
        return jws.getDecodedJwsPayload();
    }

    public static String verify(byte[] key, String algo, String content) {
        JwsCompactConsumer jws = JwsUtils.verify(JwsUtils.getHmacSignatureVerifier(key, algo), content);
        return jws.getDecodedJwsPayload();
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk) {
        return JwsUtils.getSignatureProvider(jwk, null);
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk, String defaultAlgorithm) {
        String signatureAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        JwsSignatureProvider theSigProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            theSigProvider = JwsUtils.getPrivateKeySignatureProvider(JwkUtils.toRSAPrivateKey(jwk), signatureAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            byte[] key = JoseUtils.decode((String)jwk.getProperty("k"));
            theSigProvider = JwsUtils.getHmacSignatureProvider(key, signatureAlgo);
        } else if ("EC".equals(jwk.getKeyType())) {
            theSigProvider = JwsUtils.getPrivateKeySignatureProvider(JwkUtils.toECPrivateKey(jwk), signatureAlgo);
        }
        return theSigProvider;
    }

    public static JwsSignatureProvider getPrivateKeySignatureProvider(PrivateKey key, String algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (key instanceof ECPrivateKey) {
            return new EcDsaJwsSignatureProvider((ECPrivateKey)key, SignatureAlgorithm.getAlgorithm(algo));
        }
        if (key instanceof RSAPrivateKey) {
            return new PrivateKeyJwsSignatureProvider(key, SignatureAlgorithm.getAlgorithm(algo));
        }
        return null;
    }

    public static JwsSignatureProvider getHmacSignatureProvider(byte[] key, String algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (AlgorithmUtils.isHmacSign(algo)) {
            return new HmacJwsSignatureProvider(key, SignatureAlgorithm.getAlgorithm(algo));
        }
        return null;
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk) {
        return JwsUtils.getSignatureVerifier(jwk, null);
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk, String defaultAlgorithm) {
        String signatureAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        JwsSignatureVerifier theVerifier = null;
        if ("RSA".equals(jwk.getKeyType())) {
            theVerifier = JwsUtils.getPublicKeySignatureVerifier(JwkUtils.toRSAPublicKey(jwk, true), signatureAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            byte[] key = JoseUtils.decode((String)jwk.getProperty("k"));
            theVerifier = JwsUtils.getHmacSignatureVerifier(key, signatureAlgo);
        } else if ("EC".equals(jwk.getKeyType())) {
            theVerifier = JwsUtils.getPublicKeySignatureVerifier(JwkUtils.toECPublicKey(jwk), signatureAlgo);
        }
        return theVerifier;
    }

    public static JwsSignatureVerifier getPublicKeySignatureVerifier(X509Certificate cert, String algo) {
        return JwsUtils.getPublicKeySignatureVerifier(cert.getPublicKey(), algo);
    }

    public static JwsSignatureVerifier getPublicKeySignatureVerifier(PublicKey key, String algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (key instanceof RSAPublicKey) {
            return new PublicKeyJwsSignatureVerifier(key, SignatureAlgorithm.getAlgorithm(algo));
        }
        if (key instanceof ECPublicKey) {
            return new EcDsaJwsSignatureVerifier(key, SignatureAlgorithm.getAlgorithm(algo));
        }
        return null;
    }

    public static JwsSignatureVerifier getHmacSignatureVerifier(byte[] key, String algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (AlgorithmUtils.isHmacSign(algo)) {
            return new HmacJwsSignatureVerifier(key, SignatureAlgorithm.getAlgorithm(algo));
        }
        return null;
    }

    public static MultivaluedMap<String, JwsJsonSignatureEntry> getJwsJsonSignatureMap(List<JwsJsonSignatureEntry> signatures) {
        MetadataMap map = new MetadataMap();
        for (JwsJsonSignatureEntry entry : signatures) {
            map.add((Object)entry.getUnionHeader().getAlgorithm(), (Object)entry);
        }
        return map;
    }

    public static JwsSignatureProvider loadSignatureProvider(boolean required) {
        return JwsUtils.loadSignatureProvider(null, required);
    }

    public static JwsSignatureProvider loadSignatureProvider(JoseHeaders headers, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_SIGNATURE_OUT_PROPS, RSSEC_SIGNATURE_PROPS);
        if (props == null) {
            return null;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(m, props, headers, false);
        if (headers != null) {
            headers.setAlgorithm(theSigProvider.getAlgorithm().getJwaName());
        }
        return theSigProvider;
    }

    public static JwsSignatureVerifier loadSignatureVerifier(boolean required) {
        return JwsUtils.loadSignatureVerifier(null, required);
    }

    public static JwsSignatureVerifier loadSignatureVerifier(JoseHeaders headers, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_SIGNATURE_IN_PROPS, RSSEC_SIGNATURE_PROPS);
        if (props == null) {
            return null;
        }
        return JwsUtils.loadSignatureVerifier(m, props, headers, false);
    }

    public static List<JwsSignatureProvider> loadSignatureProviders(String propLoc, Message m) {
        List<JsonWebKey> jwks;
        Properties props = JwsUtils.loadJwsProperties(m, propLoc);
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(m, props, null, true);
        if (theSigProvider != null) {
            return Collections.singletonList(theSigProvider);
        }
        ArrayList<JwsSignatureProvider> theSigProviders = null;
        if ("jwk".equals(props.get("rs.security.keystore.type")) && (jwks = JwkUtils.loadJsonWebKeys(m, props, "sign")) != null) {
            theSigProviders = new ArrayList<JwsSignatureProvider>(jwks.size());
            for (JsonWebKey jwk : jwks) {
                theSigProviders.add(JwsUtils.getSignatureProvider(jwk));
            }
        }
        if (theSigProviders == null) {
            LOG.warning("Providers are not available");
            throw new JwsException(JwsException.Error.NO_PROVIDER);
        }
        return theSigProviders;
    }

    public static List<JwsSignatureVerifier> loadSignatureVerifiers(String propLoc, Message m) {
        List<JsonWebKey> jwks;
        Properties props = JwsUtils.loadJwsProperties(m, propLoc);
        JwsSignatureVerifier theVerifier = JwsUtils.loadSignatureVerifier(m, props, null, true);
        if (theVerifier != null) {
            return Collections.singletonList(theVerifier);
        }
        ArrayList<JwsSignatureVerifier> theVerifiers = null;
        if ("jwk".equals(props.get("rs.security.keystore.type")) && (jwks = JwkUtils.loadJsonWebKeys(m, props, "verify")) != null) {
            theVerifiers = new ArrayList<JwsSignatureVerifier>(jwks.size());
            for (JsonWebKey jwk : jwks) {
                theVerifiers.add(JwsUtils.getSignatureVerifier(jwk));
            }
        }
        if (theVerifiers == null) {
            LOG.warning("Verifiers are not available");
            throw new JwsException(JwsException.Error.NO_VERIFIER);
        }
        return theVerifiers;
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        return JoseUtils.validateCriticalHeaders(headers);
    }

    private static JwsSignatureProvider loadSignatureProvider(Message m, Properties props, JoseHeaders headers, boolean ignoreNullProvider) {
        boolean reportPublicKey;
        JwsSignatureProvider theSigProvider = null;
        boolean bl = reportPublicKey = headers != null && MessageUtils.isTrue((Object)MessageUtils.getContextualProperty((Message)m, (String)JSON_WEB_SIGNATURE_REPORT_KEY_PROP, (String)"rs.security.report.public.key"));
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "sign");
            if (jwk != null) {
                String signatureAlgo = JwsUtils.getSignatureAlgo(m, props, jwk.getAlgorithm(), JwsUtils.getDefaultKeyAlgo(jwk));
                theSigProvider = JwsUtils.getSignatureProvider(jwk, signatureAlgo);
                if (reportPublicKey) {
                    JwkUtils.setPublicKeyInfo(jwk, headers, signatureAlgo);
                }
            }
        } else {
            String signatureAlgo = JwsUtils.getSignatureAlgo(m, props, null, null);
            PrivateKey pk = KeyManagementUtils.loadPrivateKey(m, props, "sign");
            theSigProvider = JwsUtils.getPrivateKeySignatureProvider(pk, signatureAlgo);
            if (reportPublicKey) {
                headers.setX509Chain(KeyManagementUtils.loadAndEncodeX509CertificateOrChain(m, props));
            }
        }
        if (theSigProvider == null && !ignoreNullProvider) {
            LOG.warning("Provider is not available");
            throw new JwsException(JwsException.Error.NO_PROVIDER);
        }
        return theSigProvider;
    }

    private static JwsSignatureVerifier loadSignatureVerifier(Message m, Properties props, JoseHeaders inHeaders, boolean ignoreNullVerifier) {
        JwsSignatureVerifier theVerifier = null;
        if (inHeaders != null) {
            if (inHeaders.getHeader("jwk") != null) {
                JsonWebKey publicJwk = inHeaders.getJsonWebKey();
                return JwsUtils.getSignatureVerifier(publicJwk, inHeaders.getAlgorithm());
            }
            if (inHeaders.getHeader("x5c") != null) {
                List<X509Certificate> chain = KeyManagementUtils.toX509CertificateChain(inHeaders.getX509Chain());
                KeyManagementUtils.validateCertificateChain(props, chain);
                return JwsUtils.getPublicKeySignatureVerifier(chain.get(0).getPublicKey(), inHeaders.getAlgorithm());
            }
        }
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "verify");
            if (jwk != null) {
                String signatureAlgo = JwsUtils.getSignatureAlgo(m, props, jwk.getAlgorithm(), JwsUtils.getDefaultKeyAlgo(jwk));
                theVerifier = JwsUtils.getSignatureVerifier(jwk, signatureAlgo);
            }
        } else {
            String signatureAlgo = JwsUtils.getSignatureAlgo(m, props, null, null);
            theVerifier = JwsUtils.getPublicKeySignatureVerifier(KeyManagementUtils.loadPublicKey(m, props), signatureAlgo);
        }
        if (theVerifier == null && !ignoreNullVerifier) {
            LOG.warning("Verifier is not available");
            throw new JwsException(JwsException.Error.NO_VERIFIER);
        }
        return theVerifier;
    }

    private static Properties loadJwsProperties(Message m, String propLoc) {
        try {
            return ResourceUtils.loadProperties((String)propLoc, (Bus)m.getExchange().getBus());
        }
        catch (Exception ex) {
            LOG.warning("JWS init properties are not available");
            throw new JwsException(JwsException.Error.NO_INIT_PROPERTIES);
        }
    }

    private static String getSignatureAlgo(Message m, Properties props, String algo, String defaultAlgo) {
        if (algo == null) {
            if (defaultAlgo == null) {
                defaultAlgo = "RS256";
            }
            return KeyManagementUtils.getKeyAlgorithm(m, props, JSON_WEB_SIGNATURE_ALGO_PROP, defaultAlgo);
        }
        return algo;
    }

    private static String getDefaultKeyAlgo(JsonWebKey jwk) {
        if ("oct".equals(jwk.getKeyType())) {
            return "HS256";
        }
        if ("EC".equals(jwk.getKeyType())) {
            return "ES256";
        }
        return "RS256";
    }

    public static JwsCompactConsumer verify(JwsSignatureVerifier v, String content) {
        JwsCompactConsumer jws = new JwsCompactConsumer(content);
        if (!jws.verifySignatureWith(v)) {
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
        return jws;
    }

    public static String sign(JwsSignatureProvider jwsSig, String content, String ct) {
        JwsHeaders headers = new JwsHeaders();
        if (ct != null) {
            headers.setContentType(ct);
        }
        JwsCompactProducer jws = new JwsCompactProducer(headers, content);
        jws.signWith(jwsSig);
        return jws.getSignedEncodedJws();
    }

    public static void validateJwsCertificateChain(List<X509Certificate> certs) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, true, RSSEC_SIGNATURE_IN_PROPS, RSSEC_SIGNATURE_PROPS);
        KeyManagementUtils.validateCertificateChain(props, certs);
    }
}

