/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;

public abstract class AbstractJoseJwtConsumer {
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;

    protected JwtToken getJwtToken(String wrappedJwtToken, boolean jweOnly) {
        JweDecryptionProvider theJweDecryptor = this.getInitializedDecryptionProvider(jweOnly);
        if (theJweDecryptor != null) {
            if (jweOnly) {
                return new JweJwtCompactConsumer(wrappedJwtToken).decryptWith(this.jweDecryptor);
            }
            wrappedJwtToken = this.jweDecryptor.decrypt(wrappedJwtToken).getContentText();
        } else if (jweOnly) {
            throw new SecurityException();
        }
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(wrappedJwtToken);
        JwtToken jwt = jwtConsumer.getJwtToken();
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        return this.validateToken(jwtConsumer, jwt, theSigVerifier);
    }

    protected JwtToken validateToken(JwsJwtCompactConsumer consumer, JwtToken jwt, JwsSignatureVerifier jws) {
        if (!consumer.verifySignatureWith(jws)) {
            throw new SecurityException("Invalid Signature");
        }
        return jwt;
    }

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public void setJweVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(boolean jweOnly) {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider(jweOnly);
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        return JwsUtils.loadSignatureVerifier(true);
    }
}

