/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public class JweJwtCompactProducer {
    private JweHeaders headers;
    private String claimsJson;

    public JweJwtCompactProducer(JwtToken token) {
        this(token.getHeaders(), token.getClaims());
    }

    public JweJwtCompactProducer(JwtClaims claims) {
        this(new JoseHeaders(), claims);
    }

    public JweJwtCompactProducer(JoseHeaders joseHeaders, JwtClaims claims) {
        this.headers = new JweHeaders(joseHeaders);
        this.claimsJson = JwtUtils.claimsToJson(claims);
    }

    public String encryptWith(JsonWebKey key) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(key, this.headers);
        return this.encryptWith(jwe);
    }

    public String encryptWith(RSAPublicKey key) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(key, this.headers);
        return this.encryptWith(jwe);
    }

    public String encryptWith(SecretKey key) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(key, this.headers);
        return this.encryptWith(jwe);
    }

    public String encryptWith(JweEncryptionProvider jwe) {
        return jwe.encrypt(StringUtils.toBytesUTF8((String)this.claimsJson), this.headers);
    }
}

