/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jaxrs.PrivateKeyPasswordProvider;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.DefaultJwkReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkReaderWriter;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public final class JwkUtils {
    public static final String JWK_KEY_STORE_TYPE = "jwk";
    public static final String RSSEC_KEY_STORE_JWKSET = "rs.security.keystore.jwkset";
    public static final String RSSEC_KEY_STORE_JWKKEY = "rs.security.keystore.jwkkey";

    private JwkUtils() {
    }

    public static JsonWebKey readJwkKey(URI uri) throws IOException {
        return JwkUtils.readJwkKey(uri.toURL().openStream());
    }

    public static JsonWebKeys readJwkSet(URI uri) throws IOException {
        return JwkUtils.readJwkSet(uri.toURL().openStream());
    }

    public static JsonWebKey readJwkKey(InputStream is) throws IOException {
        return JwkUtils.readJwkKey(IOUtils.readStringFromStream((InputStream)is));
    }

    public static JsonWebKeys readJwkSet(InputStream is) throws IOException {
        return JwkUtils.readJwkSet(IOUtils.readStringFromStream((InputStream)is));
    }

    public static JsonWebKey readJwkKey(String jwkJson) {
        return new DefaultJwkReaderWriter().jsonToJwk(jwkJson);
    }

    public static JsonWebKeys readJwkSet(String jwksJson) {
        return new DefaultJwkReaderWriter().jsonToJwkSet(jwksJson);
    }

    public static String jwkKeyToJson(JsonWebKey jwkKey) {
        return new DefaultJwkReaderWriter().jwkToJson(jwkKey);
    }

    public static String jwkSetToJson(JsonWebKeys jwkSet) {
        return new DefaultJwkReaderWriter().jwkSetToJson(jwkSet);
    }

    public static String encodeJwkKey(JsonWebKey jwkKey) {
        return Base64UrlUtility.encode((String)JwkUtils.jwkKeyToJson(jwkKey));
    }

    public static String encodeJwkSet(JsonWebKeys jwkSet) {
        return Base64UrlUtility.encode((String)JwkUtils.jwkSetToJson(jwkSet));
    }

    public static JsonWebKey decodeJwkKey(String jwkJson) {
        return JwkUtils.readJwkKey(JoseUtils.decodeToString(jwkJson));
    }

    public static JsonWebKeys decodeJwkSet(String jwksJson) {
        return JwkUtils.readJwkSet(JoseUtils.decodeToString(jwksJson));
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, char[] password) {
        return JwkUtils.encryptJwkSet(jwkSet, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, char[] password, JwkReaderWriter writer) {
        return JwkUtils.encryptJwkSet(jwkSet, JwkUtils.createDefaultEncryption(password), writer);
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, JweEncryptionProvider jwe, JwkReaderWriter writer) {
        return jwe.encrypt(StringUtils.toBytesUTF8((String)writer.jwkSetToJson(jwkSet)), JwkUtils.toJweHeaders("jwk-set+json"));
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, RSAPublicKey key, String keyAlgo, String contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8((String)JwkUtils.jwkSetToJson(jwkSet)), "jwk-set+json");
    }

    public static String signJwkSet(JsonWebKeys jwkSet, RSAPrivateKey key, String algo) {
        return JwsUtils.sign(key, algo, JwkUtils.jwkSetToJson(jwkSet), "jwk-set+json");
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, SecretKey key, String keyAlgo, String contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8((String)JwkUtils.jwkSetToJson(jwkSet)), "jwk-set+json");
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, char[] password) {
        return JwkUtils.decryptJwkSet(jsonJwkSet, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, char[] password, JwkReaderWriter reader) {
        return JwkUtils.decryptJwkSet(jsonJwkSet, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, JweDecryptionProvider jwe, JwkReaderWriter reader) {
        return reader.jsonToJwkSet(jwe.decrypt(jsonJwkSet).getContentText());
    }

    public static JsonWebKeys decryptJwkSet(RSAPrivateKey key, String keyAlgo, String ctAlgo, String jsonJwkSet) {
        return JwkUtils.readJwkSet(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwkSet)));
    }

    public static JsonWebKeys verifyJwkSet(RSAPublicKey key, String keyAlgo, String jsonJwk) {
        return JwkUtils.readJwkSet(JwsUtils.verify(key, keyAlgo, jsonJwk));
    }

    public static JsonWebKeys decryptJwkSet(SecretKey key, String keyAlgo, String ctAlgo, String jsonJwkSet) {
        return JwkUtils.readJwkSet(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwkSet)));
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, char[] password) throws IOException {
        return JwkUtils.decryptJwkSet(is, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, char[] password, JwkReaderWriter reader) throws IOException {
        return JwkUtils.decryptJwkSet(is, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, JweDecryptionProvider jwe, JwkReaderWriter reader) throws IOException {
        return reader.jsonToJwkSet(jwe.decrypt(IOUtils.readStringFromStream((InputStream)is)).getContentText());
    }

    public static String encryptJwkKey(JsonWebKey jwk, char[] password) {
        return JwkUtils.encryptJwkKey(jwk, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, char[] password, JwkReaderWriter writer) {
        return JwkUtils.encryptJwkKey(jwkKey, JwkUtils.createDefaultEncryption(password), writer);
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, JweEncryptionProvider jwe, JwkReaderWriter writer) {
        return jwe.encrypt(StringUtils.toBytesUTF8((String)writer.jwkToJson(jwkKey)), JwkUtils.toJweHeaders("jwk+json"));
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, RSAPublicKey key, String keyAlgo, String contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8((String)JwkUtils.jwkKeyToJson(jwkKey)), "jwk+json");
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, SecretKey key, String keyAlgo, String contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8((String)JwkUtils.jwkKeyToJson(jwkKey)), "jwk+json");
    }

    public static String signJwkKey(JsonWebKey jwkKey, RSAPrivateKey key, String algo) {
        return JwsUtils.sign(key, algo, JwkUtils.jwkKeyToJson(jwkKey), "jwk+json");
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, char[] password) {
        return JwkUtils.decryptJwkKey(jsonJwkKey, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, char[] password, JwkReaderWriter reader) {
        return JwkUtils.decryptJwkKey(jsonJwkKey, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKey decryptJwkKey(RSAPrivateKey key, String keyAlgo, String ctAlgo, String jsonJwk) {
        return JwkUtils.readJwkKey(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwk)));
    }

    public static JsonWebKey verifyJwkKey(RSAPublicKey key, String keyAlgo, String jsonJwk) {
        return JwkUtils.readJwkKey(JwsUtils.verify(key, keyAlgo, jsonJwk));
    }

    public static JsonWebKey decryptJwkKey(SecretKey key, String keyAlgo, String ctAlgo, String jsonJwk) {
        return JwkUtils.readJwkKey(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwk)));
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, JweDecryptionProvider jwe, JwkReaderWriter reader) {
        return reader.jsonToJwk(jwe.decrypt(jsonJwkKey).getContentText());
    }

    public static JsonWebKey decryptJwkKey(InputStream is, char[] password) throws IOException {
        return JwkUtils.decryptJwkKey(is, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKey decryptJwkKey(InputStream is, char[] password, JwkReaderWriter reader) throws IOException {
        return JwkUtils.decryptJwkKey(is, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKey decryptJwkKey(InputStream is, JweDecryptionProvider jwe, JwkReaderWriter reader) throws IOException {
        return reader.jsonToJwk(jwe.decrypt(IOUtils.readStringFromStream((InputStream)is)).getContentText());
    }

    public static JsonWebKeys loadJwkSet(Message m, Properties props, PrivateKeyPasswordProvider cb) {
        return JwkUtils.loadJwkSet(m, props, cb, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys loadJwkSet(Message m, Properties props, PrivateKeyPasswordProvider cb, JwkReaderWriter reader) {
        JsonWebKeys jwkSet;
        String key = (String)props.get("rs.security.keystore.file");
        JsonWebKeys jsonWebKeys = jwkSet = key != null ? (JsonWebKeys)((Object)m.getExchange().get((Object)key)) : null;
        if (jwkSet == null) {
            jwkSet = JwkUtils.loadJwkSet(props, m.getExchange().getBus(), cb, reader);
            if (key != null) {
                m.getExchange().put((Object)key, (Object)jwkSet);
            }
        }
        return jwkSet;
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, PrivateKeyPasswordProvider cb) {
        return JwkUtils.loadJwkSet(props, bus, cb, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, PrivateKeyPasswordProvider cb, JwkReaderWriter reader) {
        AesCbcHmacJweDecryption decryption = cb != null ? new AesCbcHmacJweDecryption(new PbesHmacAesWrapKeyDecryptionAlgorithm(cb.getPassword(props))) : null;
        return JwkUtils.loadJwkSet(props, bus, decryption, reader);
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, JweDecryptionProvider jwe, JwkReaderWriter reader) {
        String keyContent = null;
        String keyStoreLoc = props.getProperty("rs.security.keystore.file");
        if (keyStoreLoc != null) {
            try {
                InputStream is = ResourceUtils.getResourceStream((String)keyStoreLoc, (Bus)bus);
                if (is == null) {
                    throw new SecurityException("Error in loading keystore location: " + keyStoreLoc);
                }
                keyContent = IOUtils.readStringFromStream((InputStream)is);
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        } else {
            keyContent = props.getProperty(RSSEC_KEY_STORE_JWKSET);
            if (keyContent == null) {
                keyContent = props.getProperty(RSSEC_KEY_STORE_JWKKEY);
            }
        }
        if (jwe != null) {
            keyContent = jwe.decrypt(keyContent).getContentText();
        }
        if (props.getProperty(RSSEC_KEY_STORE_JWKKEY) == null) {
            return reader.jsonToJwkSet(keyContent);
        }
        JsonWebKey key = reader.jsonToJwk(keyContent);
        JsonWebKeys keys = new JsonWebKeys();
        keys.setKeys(Collections.singletonList(key));
        return keys;
    }

    public static JsonWebKey loadJsonWebKey(Message m, Properties props, String keyOper) {
        return JwkUtils.loadJsonWebKey(m, props, keyOper, new DefaultJwkReaderWriter());
    }

    public static JsonWebKey loadJsonWebKey(Message m, Properties props, String keyOper, JwkReaderWriter reader) {
        List<JsonWebKey> keys;
        PrivateKeyPasswordProvider cb = KeyManagementUtils.loadPasswordProvider(m, props, keyOper);
        JsonWebKeys jwkSet = JwkUtils.loadJwkSet(m, props, cb, reader);
        String kid = KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.alias", keyOper);
        if (kid != null) {
            return jwkSet.getKey(kid);
        }
        if (keyOper != null && (keys = jwkSet.getKeyUseMap().get(keyOper)) != null && keys.size() == 1) {
            return keys.get(0);
        }
        return null;
    }

    public static List<JsonWebKey> loadJsonWebKeys(Message m, Properties props, String keyOper) {
        return JwkUtils.loadJsonWebKeys(m, props, keyOper, new DefaultJwkReaderWriter());
    }

    public static List<JsonWebKey> loadJsonWebKeys(Message m, Properties props, String keyOper, JwkReaderWriter reader) {
        List<JsonWebKey> keys;
        PrivateKeyPasswordProvider cb = KeyManagementUtils.loadPasswordProvider(m, props, keyOper);
        JsonWebKeys jwkSet = JwkUtils.loadJwkSet(m, props, cb, reader);
        String kid = KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.alias", keyOper);
        if (kid != null) {
            return Collections.singletonList(jwkSet.getKey(kid));
        }
        String kids = KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.aliases", keyOper);
        if (kids != null) {
            String[] values = kids.split(",");
            ArrayList<JsonWebKey> keys2 = new ArrayList<JsonWebKey>(values.length);
            for (String value : values) {
                keys2.add(jwkSet.getKey(value));
            }
            return keys2;
        }
        if (keyOper != null && (keys = jwkSet.getKeyUseMap().get(keyOper)) != null && keys.size() == 1) {
            return Collections.singletonList(keys.get(0));
        }
        return null;
    }

    public static RSAPublicKey toRSAPublicKey(JsonWebKey jwk) {
        return JwkUtils.toRSAPublicKey(jwk, false);
    }

    public static RSAPublicKey toRSAPublicKey(JsonWebKey jwk, boolean checkX509) {
        String encodedModulus = (String)jwk.getProperty("n");
        String encodedPublicExponent = (String)jwk.getProperty("e");
        if (encodedModulus != null) {
            return CryptoUtils.getRSAPublicKey((String)encodedModulus, (String)encodedPublicExponent);
        }
        if (checkX509) {
            List<X509Certificate> chain = JwkUtils.toX509CertificateChain(jwk);
            return (RSAPublicKey)chain.get(0).getPublicKey();
        }
        return null;
    }

    public static List<X509Certificate> toX509CertificateChain(JsonWebKey jwk) {
        List<String> base64EncodedChain = jwk.getX509Chain();
        return KeyManagementUtils.toX509CertificateChain(base64EncodedChain);
    }

    public static JsonWebKey fromECPublicKey(ECPublicKey pk, String curve) {
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType("EC");
        jwk.setProperty("crv", curve);
        jwk.setProperty("x", Base64UrlUtility.encode((byte[])pk.getW().getAffineX().toByteArray()));
        jwk.setProperty("y", Base64UrlUtility.encode((byte[])pk.getW().getAffineY().toByteArray()));
        return jwk;
    }

    public static JsonWebKey fromECPrivateKey(ECPrivateKey pk, String curve) {
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType("EC");
        jwk.setProperty("crv", curve);
        jwk.setProperty("d", Base64UrlUtility.encode((byte[])pk.getS().toByteArray()));
        return jwk;
    }

    public static JsonWebKey fromRSAPublicKey(RSAPublicKey pk, String algo) {
        JsonWebKey jwk = JwkUtils.prepareRSAJwk(pk.getModulus(), algo);
        String encodedPublicExponent = Base64UrlUtility.encode((byte[])pk.getPublicExponent().toByteArray());
        jwk.setProperty("e", encodedPublicExponent);
        return jwk;
    }

    public static JsonWebKey fromX509CertificateChain(List<X509Certificate> chain, String algo) {
        JsonWebKey jwk = new JsonWebKey();
        jwk.setAlgorithm(algo);
        List<String> encodedChain = KeyManagementUtils.encodeX509CertificateChain(chain);
        jwk.setX509Chain(encodedChain);
        return jwk;
    }

    public static RSAPrivateKey toRSAPrivateKey(JsonWebKey jwk) {
        String encodedModulus = (String)jwk.getProperty("n");
        String encodedPrivateExponent = (String)jwk.getProperty("d");
        String encodedPrimeP = (String)jwk.getProperty("p");
        if (encodedPrimeP == null) {
            return CryptoUtils.getRSAPrivateKey((String)encodedModulus, (String)encodedPrivateExponent);
        }
        String encodedPublicExponent = (String)jwk.getProperty("e");
        String encodedPrimeQ = (String)jwk.getProperty("q");
        String encodedPrimeExpP = (String)jwk.getProperty("dp");
        String encodedPrimeExpQ = (String)jwk.getProperty("dq");
        String encodedCrtCoefficient = (String)jwk.getProperty("qi");
        return CryptoUtils.getRSAPrivateKey((String)encodedModulus, (String)encodedPublicExponent, (String)encodedPrivateExponent, (String)encodedPrimeP, (String)encodedPrimeQ, (String)encodedPrimeExpP, (String)encodedPrimeExpQ, (String)encodedCrtCoefficient);
    }

    public static JsonWebKey fromRSAPrivateKey(RSAPrivateKey pk, String algo) {
        JsonWebKey jwk = JwkUtils.prepareRSAJwk(pk.getModulus(), algo);
        String encodedPrivateExponent = Base64UrlUtility.encode((byte[])pk.getPrivateExponent().toByteArray());
        jwk.setProperty("d", encodedPrivateExponent);
        if (pk instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey pkCrt = (RSAPrivateCrtKey)pk;
            jwk.setProperty("p", Base64UrlUtility.encode((byte[])pkCrt.getPrimeP().toByteArray()));
            jwk.setProperty("q", Base64UrlUtility.encode((byte[])pkCrt.getPrimeQ().toByteArray()));
            jwk.setProperty("dp", Base64UrlUtility.encode((byte[])pkCrt.getPrimeExponentP().toByteArray()));
            jwk.setProperty("dq", Base64UrlUtility.encode((byte[])pkCrt.getPrimeExponentQ().toByteArray()));
            jwk.setProperty("qi", Base64UrlUtility.encode((byte[])pkCrt.getCrtCoefficient().toByteArray()));
        }
        return jwk;
    }

    public static ECPublicKey toECPublicKey(JsonWebKey jwk) {
        String eCurve = (String)jwk.getProperty("crv");
        String encodedXCoord = (String)jwk.getProperty("x");
        String encodedYCoord = (String)jwk.getProperty("y");
        return CryptoUtils.getECPublicKey((String)eCurve, (String)encodedXCoord, (String)encodedYCoord);
    }

    public static ECPrivateKey toECPrivateKey(JsonWebKey jwk) {
        String eCurve = (String)jwk.getProperty("crv");
        String encodedPrivateKey = (String)jwk.getProperty("d");
        return CryptoUtils.getECPrivateKey((String)eCurve, (String)encodedPrivateKey);
    }

    public static SecretKey toSecretKey(JsonWebKey jwk) {
        return CryptoUtils.createSecretKeySpec((String)((String)jwk.getProperty("k")), (String)AlgorithmUtils.toJavaName(jwk.getAlgorithm()));
    }

    public static JsonWebKey fromSecretKey(SecretKey secretKey, String algo) {
        if (!AlgorithmUtils.isOctet(algo)) {
            throw new SecurityException("Invalid algorithm");
        }
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType("oct");
        jwk.setAlgorithm(algo);
        String encodedSecretKey = Base64UrlUtility.encode((byte[])secretKey.getEncoded());
        jwk.setProperty("k", encodedSecretKey);
        return jwk;
    }

    private static JweEncryptionProvider createDefaultEncryption(char[] password) {
        PbesHmacAesWrapKeyEncryptionAlgorithm keyEncryption = new PbesHmacAesWrapKeyEncryptionAlgorithm(password, KeyAlgorithm.PBES2_HS256_A128KW);
        return new AesCbcHmacJweEncryption(ContentAlgorithm.A128CBC_HS256, (KeyEncryptionProvider)keyEncryption);
    }

    private static JweDecryptionProvider createDefaultDecryption(char[] password) {
        PbesHmacAesWrapKeyDecryptionAlgorithm keyDecryption = new PbesHmacAesWrapKeyDecryptionAlgorithm(password);
        return new AesCbcHmacJweDecryption(keyDecryption);
    }

    private static JsonWebKey prepareRSAJwk(BigInteger modulus, String algo) {
        if (!AlgorithmUtils.isRsa(algo)) {
            throw new SecurityException("Invalid algorithm");
        }
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType("RSA");
        jwk.setAlgorithm(algo);
        String encodedModulus = Base64UrlUtility.encode((byte[])modulus.toByteArray());
        jwk.setProperty("n", encodedModulus);
        return jwk;
    }

    private static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static JweHeaders toJweHeaders(String ct) {
        return new JweHeaders(Collections.singletonMap("cty", ct));
    }

    public static void setPublicKeyInfo(JsonWebKey jwk, JoseHeaders headers, String algo) {
        if ("RSA".equals(jwk.getKeyType())) {
            List chain = CastUtils.cast((List)((List)jwk.getProperty("x5c")));
            if (chain != null) {
                headers.setX509Chain(chain);
            } else {
                headers.setJsonWebKey(JwkUtils.fromRSAPublicKey(JwkUtils.toRSAPublicKey(jwk), algo));
            }
        }
    }
}

