/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;

public class JwsOutputStream
extends FilterOutputStream {
    private boolean flushed;
    private JwsSignature signature;

    public JwsOutputStream(OutputStream out, JwsSignature signature) {
        super(out);
        this.signature = signature;
    }

    @Override
    public void write(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).putInt(value).array();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.signature.update(b, off, len);
        this.out.write(b, off, len);
        this.out.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        byte[] finalBytes = this.signature.sign();
        this.out.write(new byte[]{46});
        Base64UrlUtility.encodeAndStream((byte[])finalBytes, (int)0, (int)finalBytes.length, (OutputStream)this.out);
        this.flushed = true;
    }
}

