/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.Map;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.provider.json.JsonMapObject;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseType;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;

public class JweHeaders
extends JoseHeaders {
    private JweHeaders protectedHeaders;

    public JweHeaders() {
    }

    public JweHeaders(JoseType type) {
        super(type);
    }

    public JweHeaders(JoseHeaders headers) {
        super(headers.asMap());
    }

    public JweHeaders(Map<String, Object> values) {
        super(values);
    }

    public JweHeaders(KeyAlgorithm keyEncAlgo, ContentAlgorithm ctEncAlgo) {
        this(keyEncAlgo, ctEncAlgo, false);
    }

    public JweHeaders(ContentAlgorithm ctEncAlgo) {
        this(null, ctEncAlgo, false);
    }

    public JweHeaders(ContentAlgorithm ctEncAlgo, boolean deflate) {
        this(null, ctEncAlgo, deflate);
    }

    public JweHeaders(KeyAlgorithm keyEncAlgo, ContentAlgorithm ctEncAlgo, boolean deflate) {
        this.init(keyEncAlgo, ctEncAlgo, deflate);
    }

    private void init(KeyAlgorithm keyEncAlgo, ContentAlgorithm ctEncAlgo, boolean deflate) {
        if (keyEncAlgo != null) {
            this.setKeyEncryptionAlgorithm(keyEncAlgo);
        }
        this.setContentEncryptionAlgorithm(ctEncAlgo);
        if (deflate) {
            this.setZipAlgorithm("DEF");
        }
    }

    public void setKeyEncryptionAlgorithm(KeyAlgorithm algo) {
        super.setAlgorithm(algo.getJwaName());
    }

    public KeyAlgorithm getKeyEncryptionAlgorithm() {
        String algo = super.getAlgorithm();
        return algo == null ? null : KeyAlgorithm.getAlgorithm(algo);
    }

    public void setContentEncryptionAlgorithm(ContentAlgorithm algo) {
        this.setHeader("enc", algo.getJwaName());
    }

    public ContentAlgorithm getContentEncryptionAlgorithm() {
        Object prop = this.getHeader("enc");
        return prop == null ? null : ContentAlgorithm.getAlgorithm(prop.toString());
    }

    public void setZipAlgorithm(String type) {
        this.setHeader("zip", type);
    }

    public String getZipAlgorithm() {
        return (String)this.getHeader("zip");
    }

    @Override
    public JoseHeaders setHeader(String name, Object value) {
        return super.setHeader(name, value);
    }

    public byte[] toCipherAdditionalAuthData() {
        return JweHeaders.toCipherAdditionalAuthData(new JsonMapObjectReaderWriter().toJson((JsonMapObject)this));
    }

    public static byte[] toCipherAdditionalAuthData(String headersJson) {
        byte[] headerBytes = StringUtils.toBytesUTF8((String)headersJson);
        String base64UrlHeadersInJson = Base64UrlUtility.encode((byte[])headerBytes);
        return StringUtils.toBytesASCII((String)base64UrlHeadersInJson);
    }

    public JweHeaders getProtectedHeaders() {
        return this.protectedHeaders;
    }

    public void setProtectedHeaders(JweHeaders protectedHeaders) {
        this.protectedHeaders = protectedHeaders;
    }
}

