/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.KeyProperties;

public class WrappedKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    protected static final Logger LOG = LogUtils.getL7dLogger(WrappedKeyDecryptionAlgorithm.class);
    private Key cekDecryptionKey;
    private boolean unwrap;
    private KeyAlgorithm supportedAlgo;

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey, KeyAlgorithm supportedAlgo) {
        this(cekDecryptionKey, supportedAlgo, true);
    }

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey, KeyAlgorithm supportedAlgo, boolean unwrap) {
        this.cekDecryptionKey = cekDecryptionKey;
        this.supportedAlgo = supportedAlgo;
        this.unwrap = unwrap;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        KeyProperties keyProps = new KeyProperties(this.getKeyEncryptionAlgorithm(jweDecryptionInput));
        AlgorithmParameterSpec spec = this.getAlgorithmParameterSpec(jweDecryptionInput);
        if (spec != null) {
            keyProps.setAlgoSpec(spec);
        }
        if (!this.unwrap) {
            keyProps.setBlockSize(this.getKeyCipherBlockSize());
            return CryptoUtils.decryptBytes((byte[])this.getEncryptedContentEncryptionKey(jweDecryptionInput), (Key)this.getCekDecryptionKey(), (KeyProperties)keyProps);
        }
        return CryptoUtils.unwrapSecretKey((byte[])this.getEncryptedContentEncryptionKey(jweDecryptionInput), (String)this.getContentEncryptionAlgorithm(jweDecryptionInput), (Key)this.getCekDecryptionKey(), (KeyProperties)keyProps).getEncoded();
    }

    protected Key getCekDecryptionKey() {
        return this.cekDecryptionKey;
    }

    protected int getKeyCipherBlockSize() {
        return -1;
    }

    protected String getKeyEncryptionAlgorithm(JweDecryptionInput jweDecryptionInput) {
        String keyAlgo = jweDecryptionInput.getJweHeaders().getKeyEncryptionAlgorithm().getJwaName();
        this.validateKeyEncryptionAlgorithm(keyAlgo);
        return AlgorithmUtils.toJavaName(keyAlgo);
    }

    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        if (keyAlgo == null || !this.supportedAlgo.getJwaName().equals(keyAlgo)) {
            this.reportInvalidKeyAlgorithm(keyAlgo);
        }
    }

    protected void reportInvalidKeyAlgorithm(String keyAlgo) {
        LOG.warning("Invalid key encryption algorithm: " + keyAlgo);
        throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
    }

    protected String getContentEncryptionAlgorithm(JweDecryptionInput jweDecryptionInput) {
        return AlgorithmUtils.toJavaName(jweDecryptionInput.getJweHeaders().getContentEncryptionAlgorithm().getJwaName());
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweDecryptionInput jweDecryptionInput) {
        return null;
    }

    protected byte[] getEncryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        return jweDecryptionInput.getEncryptedCEK();
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return this.supportedAlgo;
    }
}

