/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReaderWriter;

public final class JwtUtils {
    private JwtUtils() {
    }

    public static String claimsToJson(JwtClaims claims) {
        return JwtUtils.claimsToJson(claims, null);
    }

    public static String claimsToJson(JwtClaims claims, JwtTokenReaderWriter writer) {
        if (writer == null) {
            writer = new JwtTokenReaderWriter();
        }
        return writer.claimsToJson(claims);
    }

    public static JwtClaims jsonToClaims(String json) {
        return new JwtTokenReaderWriter().fromJsonClaims(json);
    }

    public static void validateJwtTimeClaims(JwtClaims claims, int clockOffset, int issuedAtRange, boolean claimsRequired) {
        Long currentTimeInSecs = System.currentTimeMillis() / 1000L;
        Long expiryTimeInSecs = claims.getExpiryTime();
        if (expiryTimeInSecs == null && claimsRequired || expiryTimeInSecs != null && currentTimeInSecs > expiryTimeInSecs) {
            throw new JwtException("The token expired");
        }
        Long issuedAtInSecs = claims.getIssuedAt();
        if (clockOffset <= 0) {
            clockOffset = 0;
        }
        if (issuedAtInSecs == null && claimsRequired || issuedAtInSecs != null && (issuedAtInSecs - (long)clockOffset > currentTimeInSecs || issuedAtRange > 0 && issuedAtInSecs < currentTimeInSecs - (long)issuedAtRange)) {
            throw new JwtException("Invalid issuedAt");
        }
    }

    public static void validateJwtTimeClaims(JwtClaims claims) {
        JwtUtils.validateJwtTimeClaims(claims, 0, 0, false);
    }
}

