/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jwk.KeyType;

public class JsonWebKeys
extends JsonMapObject {
    public static final String KEYS_PROPERTY = "keys";

    public List<JsonWebKey> getKeys() {
        List list = (List)super.getProperty(KEYS_PROPERTY);
        if (list != null && !list.isEmpty()) {
            Object first = list.get(0);
            if (first instanceof JsonWebKey) {
                return CastUtils.cast((List)list);
            }
            LinkedList<JsonWebKey> keys = new LinkedList<JsonWebKey>();
            List listOfMaps = CastUtils.cast((List)((List)super.getProperty(KEYS_PROPERTY)));
            for (Map map : listOfMaps) {
                keys.add(new JsonWebKey(map));
            }
            return keys;
        }
        return null;
    }

    public void setKeys(List<JsonWebKey> keys) {
        super.setProperty(KEYS_PROPERTY, keys);
    }

    public Map<String, JsonWebKey> getKeyIdMap() {
        List<JsonWebKey> keys = this.getKeys();
        if (keys == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, JsonWebKey> map = new LinkedHashMap<String, JsonWebKey>();
        for (JsonWebKey key : keys) {
            String kid = key.getKeyId();
            if (kid == null) continue;
            map.put(kid, key);
        }
        return map;
    }

    public JsonWebKey getKey(String kid) {
        return this.getKeyIdMap().get(kid);
    }

    public Map<KeyType, List<JsonWebKey>> getKeyTypeMap() {
        List<JsonWebKey> keys = this.getKeys();
        if (keys == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<KeyType, List<JsonWebKey>> map = new LinkedHashMap<KeyType, List<JsonWebKey>>();
        for (JsonWebKey key : keys) {
            KeyType type = key.getKeyType();
            if (type == null) continue;
            LinkedList<JsonWebKey> list = (LinkedList<JsonWebKey>)map.get((Object)type);
            if (list == null) {
                list = new LinkedList<JsonWebKey>();
                map.put(type, list);
            }
            list.add(key);
        }
        return map;
    }

    public Map<KeyOperation, List<JsonWebKey>> getKeyOperationMap() {
        List<JsonWebKey> keys = this.getKeys();
        if (keys == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<KeyOperation, List<JsonWebKey>> map = new LinkedHashMap<KeyOperation, List<JsonWebKey>>();
        for (JsonWebKey key : keys) {
            List<KeyOperation> ops = key.getKeyOperation();
            if (ops == null) continue;
            for (KeyOperation op : ops) {
                LinkedList<JsonWebKey> list = (LinkedList<JsonWebKey>)map.get((Object)op);
                if (list == null) {
                    list = new LinkedList<JsonWebKey>();
                    map.put(op, list);
                }
                list.add(key);
            }
        }
        return map;
    }

    public List<JsonWebKey> getKeys(String keyType) {
        KeyType kt = KeyType.getKeyType(keyType);
        if (kt == null) {
            return null;
        }
        return this.getKeyTypeMap().get((Object)kt);
    }

    public List<JsonWebKey> getRsaKeys() {
        return this.getKeyTypeMap().get((Object)KeyType.RSA);
    }

    public List<JsonWebKey> getEllipticKeys() {
        return this.getKeyTypeMap().get((Object)KeyType.EC);
    }

    public List<JsonWebKey> getSecretKeys() {
        return this.getKeyTypeMap().get((Object)KeyType.OCTET);
    }
}

