/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.common.AbstractJoseConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;

public abstract class AbstractJoseJwtConsumer
extends AbstractJoseConsumer {
    private boolean jwsRequired = true;
    private boolean jweRequired;

    protected JwtToken getJwtToken(String wrappedJwtToken) {
        return this.getJwtToken(wrappedJwtToken, null, null);
    }

    protected JwtToken getJwtToken(String wrappedJwtToken, JweDecryptionProvider jweDecryptor, JwsSignatureVerifier theSigVerifier) {
        if (!this.isJwsRequired() && !this.isJweRequired()) {
            throw new JwtException("Unable to process JWT");
        }
        if (this.isJweRequired()) {
            if (jweDecryptor == null) {
                jweDecryptor = this.getInitializedDecryptionProvider();
            }
            if (jweDecryptor == null) {
                throw new JwtException("Unable to decrypt JWT");
            }
            if (!this.isJwsRequired()) {
                return new JweJwtCompactConsumer(wrappedJwtToken).decryptWith(jweDecryptor);
            }
            wrappedJwtToken = jweDecryptor.decrypt(wrappedJwtToken).getContentText();
        }
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(wrappedJwtToken);
        JwtToken jwt = jwtConsumer.getJwtToken();
        if (this.isJwsRequired()) {
            if (theSigVerifier == null) {
                theSigVerifier = this.getInitializedSignatureVerifier(jwt);
            }
            if (theSigVerifier == null) {
                throw new JwtException("Unable to validate JWT");
            }
            if (!jwtConsumer.verifySignatureWith(theSigVerifier)) {
                throw new JwtException("Invalid Signature");
            }
        }
        this.validateToken(jwt);
        return jwt;
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwtToken jwt) {
        if (super.getJwsVerifier() != null) {
            return super.getJwsVerifier();
        }
        if (jwt.getHeaders() instanceof JwsHeaders) {
            return JwsUtils.loadSignatureVerifier((JwsHeaders)jwt.getHeaders(), false);
        }
        return super.getInitializedSignatureVerifier();
    }

    protected void validateToken(JwtToken jwt) {
    }

    public boolean isJwsRequired() {
        return this.jwsRequired;
    }

    public void setJwsRequired(boolean jwsRequired) {
        this.jwsRequired = jwsRequired;
    }

    public boolean isJweRequired() {
        return this.jweRequired;
    }

    public void setJweRequired(boolean jweRequired) {
        this.jweRequired = jweRequired;
    }
}

