/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.common.PrivateKeyPasswordProvider;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public final class KeyManagementUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(KeyManagementUtils.class);

    private KeyManagementUtils() {
    }

    public static List<String> loadAndEncodeX509CertificateOrChain(Message m, Properties props) {
        X509Certificate[] chain = KeyManagementUtils.loadX509CertificateOrChain(m, props);
        return KeyManagementUtils.encodeX509CertificateChain(chain);
    }

    public static String loadDigestAndEncodeX509Certificate(Message m, Properties props, String digestAlgo) {
        X509Certificate[] certs = KeyManagementUtils.loadX509CertificateOrChain(m, props);
        if (certs != null && certs.length > 0) {
            try {
                byte[] digest = MessageDigestUtils.createDigest((byte[])certs[0].getEncoded(), (String)digestAlgo);
                return Base64UrlUtility.encode((byte[])digest);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.log(Level.FINE, "Error creating digest", ex);
                throw new JoseException(ex);
            }
            catch (CertificateEncodingException ex) {
                LOG.log(Level.FINE, "Error creating digest", ex);
                throw new JoseException(ex);
            }
        }
        return null;
    }

    public static X509Certificate[] loadX509CertificateOrChain(Message m, Properties props) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        String alias = props.getProperty("rs.security.keystore.alias");
        return KeyManagementUtils.loadX509CertificateOrChain(keyStore, alias);
    }

    private static X509Certificate[] loadX509CertificateOrChain(KeyStore keyStore, String alias) {
        if (alias == null) {
            throw new JoseException("No alias supplied");
        }
        try {
            Certificate[] certs = keyStore.getCertificateChain(alias);
            if (certs != null) {
                return (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
            }
            return new X509Certificate[]{(X509Certificate)CryptoUtils.loadCertificate((KeyStore)keyStore, (String)alias)};
        }
        catch (Exception ex) {
            LOG.warning("X509 Certificates can not be created");
            throw new JoseException(ex);
        }
    }

    public static PublicKey loadPublicKey(Message m, Properties props) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        return CryptoUtils.loadPublicKey((KeyStore)keyStore, (String)props.getProperty("rs.security.keystore.alias"));
    }

    public static PublicKey loadPublicKey(Message m, String keyStoreLocProp) {
        return KeyManagementUtils.loadPublicKey(m, keyStoreLocProp, null);
    }

    public static PublicKey loadPublicKey(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault) {
        String keyStoreLoc = KeyManagementUtils.getMessageProperty(m, keyStoreLocPropPreferred, keyStoreLocPropDefault);
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = JoseUtils.loadProperties(keyStoreLoc, bus);
            return KeyManagementUtils.loadPublicKey(m, props);
        }
        catch (Exception ex) {
            LOG.warning("Public key can not be loaded");
            throw new JoseException(ex);
        }
    }

    public static PublicKey loadPublicKey(String keyStorePropLoc, Bus bus) {
        try {
            Properties props = JoseUtils.loadProperties(keyStorePropLoc, bus);
            return KeyManagementUtils.loadPublicKey(null, props);
        }
        catch (Exception ex) {
            LOG.warning("Public key can not be loaded");
            throw new JoseException(ex);
        }
    }

    public static PublicKey loadPublicKey(String keyStoreLoc, String keyStorePassword, String keyAlias, Bus bus) {
        try {
            KeyStore keyStore = KeyManagementUtils.loadKeyStore(keyStoreLoc, null, keyStorePassword, bus);
            return CryptoUtils.loadPublicKey((KeyStore)keyStore, (String)keyAlias);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static String getMessageProperty(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault) {
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)keyStoreLocPropPreferred, (String)keyStoreLocPropDefault);
        if (propLoc == null) {
            LOG.warning("Properties resource is not identified");
            throw new JoseException();
        }
        return propLoc;
    }

    private static PrivateKey loadPrivateKey(KeyStore keyStore, Message m, Properties props, KeyOperation keyOper, String alias) {
        char[] keyPswdChars;
        String theAlias;
        String keyPswd = props.getProperty("rs.security.key.password");
        String string = theAlias = alias != null ? alias : KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.alias", keyOper);
        if (theAlias != null) {
            props.put("rs.security.keystore.alias", theAlias);
        }
        char[] cArray = keyPswdChars = keyPswd != null ? keyPswd.toCharArray() : null;
        if (keyPswdChars == null) {
            PrivateKeyPasswordProvider provider = KeyManagementUtils.loadPasswordProvider(m, props, keyOper);
            keyPswdChars = provider != null ? provider.getPassword(props) : null;
        }
        return CryptoUtils.loadPrivateKey((KeyStore)keyStore, (char[])keyPswdChars, (String)theAlias);
    }

    public static PrivateKey loadPrivateKey(Message m, String keyStoreLocProp, KeyOperation keyOper) {
        return KeyManagementUtils.loadPrivateKey(m, keyStoreLocProp, null, keyOper);
    }

    public static PrivateKey loadPrivateKey(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault, KeyOperation keyOper) {
        String keyStoreLoc = KeyManagementUtils.getMessageProperty(m, keyStoreLocPropPreferred, keyStoreLocPropDefault);
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = JoseUtils.loadProperties(keyStoreLoc, bus);
            return KeyManagementUtils.loadPrivateKey(m, props, keyOper);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static PrivateKey loadPrivateKey(String keyStoreLoc, String keyStorePassword, String keyAlias, String keyPassword, Bus bus) {
        try {
            KeyStore keyStore = KeyManagementUtils.loadKeyStore(keyStoreLoc, null, keyStorePassword, bus);
            return CryptoUtils.loadPrivateKey((KeyStore)keyStore, (char[])(keyPassword == null ? new char[]{} : keyPassword.toCharArray()), (String)keyAlias);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static PrivateKey loadPrivateKey(String keyStorePropLoc, Bus bus) {
        try {
            Properties props = JoseUtils.loadProperties(keyStorePropLoc, bus);
            return KeyManagementUtils.loadPrivateKey(null, props, null);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String getKeyId(Message m, Properties props, String preferredPropertyName, KeyOperation keyOper) {
        String kid = null;
        String altPropertyName = null;
        if (keyOper != null && m != null) {
            if (keyOper == KeyOperation.ENCRYPT || keyOper == KeyOperation.DECRYPT) {
                altPropertyName = preferredPropertyName + ".jwe";
            } else if (keyOper == KeyOperation.SIGN || keyOper == KeyOperation.VERIFY) {
                altPropertyName = preferredPropertyName + ".jws";
            }
            String direction = m.getExchange().getOutMessage() == m ? ".out" : ".in";
            kid = (String)MessageUtils.getContextualProperty((Message)m, (String)preferredPropertyName, (String)(altPropertyName + direction));
            if (kid == null && altPropertyName != null) {
                kid = (String)m.getContextualProperty(altPropertyName);
            }
        }
        if (kid == null) {
            kid = props.getProperty(preferredPropertyName);
        }
        if (kid == null && altPropertyName != null) {
            kid = props.getProperty(altPropertyName);
        }
        return kid;
    }

    public static PrivateKeyPasswordProvider loadPasswordProvider(Message m, Properties props, KeyOperation keyOper) {
        PrivateKeyPasswordProvider cb = null;
        if (keyOper != null) {
            String propName;
            String string = keyOper == KeyOperation.SIGN ? "rs.security.signature.key.password.provider" : (propName = keyOper == KeyOperation.DECRYPT ? "rs.security.decryption.key.password.provider" : null);
            if (propName != null) {
                if (props.containsKey(propName)) {
                    cb = (PrivateKeyPasswordProvider)props.get(propName);
                } else if (m != null) {
                    cb = (PrivateKeyPasswordProvider)m.getContextualProperty(propName);
                }
            }
        }
        if (cb == null) {
            if (props.containsKey("rs.security.key.password.provider")) {
                cb = (PrivateKeyPasswordProvider)props.get("rs.security.key.password.provider");
            } else if (m != null) {
                cb = (PrivateKeyPasswordProvider)m.getContextualProperty("rs.security.key.password.provider");
            }
        }
        return cb;
    }

    public static PrivateKey loadPrivateKey(Message m, Properties props, KeyOperation keyOper) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        return KeyManagementUtils.loadPrivateKey(keyStore, m, props, keyOper, null);
    }

    public static KeyStore loadPersistKeyStore(Message m, Properties props) {
        KeyStore keyStore = null;
        if (props.containsKey("rs.security.keystore")) {
            keyStore = (KeyStore)props.get("rs.security.keystore");
        }
        if (keyStore == null) {
            if (!props.containsKey("rs.security.keystore.file")) {
                LOG.warning("No keystore file has been configured");
                throw new JoseException("No keystore file has been configured");
            }
            if (m != null) {
                keyStore = (KeyStore)m.getExchange().get(props.get("rs.security.keystore.file"));
            }
        }
        if (keyStore == null) {
            Bus bus = m != null ? m.getExchange().getBus() : null;
            keyStore = KeyManagementUtils.loadKeyStore(props, bus);
            if (m != null) {
                m.getExchange().put((Object)((String)props.get("rs.security.keystore.file")), (Object)keyStore);
            }
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(Properties props, Bus bus) {
        String keyStoreLoc = props.getProperty("rs.security.keystore.file");
        String keyStoreType = props.getProperty("rs.security.keystore.type");
        String keyStorePswd = props.getProperty("rs.security.keystore.password");
        return KeyManagementUtils.loadKeyStore(keyStoreLoc, keyStoreType, keyStorePswd, bus);
    }

    public static KeyStore loadKeyStore(String keyStoreLoc, String keyStoreType, String keyStorePswd, Bus bus) {
        if (keyStorePswd == null) {
            throw new JoseException("No keystore password was defined");
        }
        try {
            InputStream is = JoseUtils.getResourceStream(keyStoreLoc, bus);
            return CryptoUtils.loadKeyStore((InputStream)is, (char[])keyStorePswd.toCharArray(), (String)keyStoreType);
        }
        catch (Exception ex) {
            LOG.warning("Key store can not be loaded");
            throw new JoseException(ex);
        }
    }

    public static List<String> encodeX509CertificateChain(X509Certificate[] chain) {
        return KeyManagementUtils.encodeX509CertificateChain(Arrays.asList(chain));
    }

    public static List<String> encodeX509CertificateChain(List<X509Certificate> chain) {
        ArrayList<String> encodedChain = new ArrayList<String>(chain.size());
        for (X509Certificate cert : chain) {
            try {
                encodedChain.add(CryptoUtils.encodeCertificate((Certificate)cert));
            }
            catch (Exception ex) {
                LOG.warning("X509 Certificate can not be encoded");
                throw new JoseException(ex);
            }
        }
        return encodedChain;
    }

    public static List<X509Certificate> toX509CertificateChain(List<String> base64EncodedChain) {
        if (base64EncodedChain != null) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(base64EncodedChain.size());
            for (String encodedCert : base64EncodedChain) {
                try {
                    certs.add((X509Certificate)CryptoUtils.decodeCertificate((String)encodedCert));
                }
                catch (Exception ex) {
                    LOG.warning("X509 Certificate can not be decoded");
                    throw new JoseException(ex);
                }
            }
            return certs;
        }
        return null;
    }

    public static void validateCertificateChain(Properties storeProperties, List<X509Certificate> inCerts) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        KeyStore ks = KeyManagementUtils.loadPersistKeyStore(message, storeProperties);
        KeyManagementUtils.validateCertificateChain(ks, inCerts);
    }

    public static void validateCertificateChain(KeyStore ks, List<X509Certificate> inCerts) {
        try {
            X509CertSelector certSelect = new X509CertSelector();
            certSelect.setCertificate(inCerts.get(0));
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(ks, (CertSelector)certSelect);
            pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(inCerts)));
            pbParams.setMaxPathLength(-1);
            pbParams.setRevocationEnabled(false);
            CertPathBuilderResult buildResult = CertPathBuilder.getInstance("PKIX").build(pbParams);
            CertPath certPath = buildResult.getCertPath();
            CertPathValidator.getInstance("PKIX").validate(certPath, pbParams);
        }
        catch (Exception ex) {
            LOG.warning("Certificate path validation error");
            throw new JoseException(ex);
        }
    }

    public static X509Certificate[] toX509CertificateChainArray(List<String> base64EncodedChain) {
        List<X509Certificate> chain = KeyManagementUtils.toX509CertificateChain(base64EncodedChain);
        return chain == null ? null : chain.toArray(new X509Certificate[0]);
    }

    public static String getKeyAlgorithm(Message m, Properties props, String propName, String defaultAlg) {
        String algo;
        String string = algo = props != null ? props.getProperty(propName) : null;
        if (algo == null && m != null) {
            algo = (String)m.getContextualProperty(propName);
        }
        if (algo == null) {
            algo = defaultAlg;
        }
        return algo;
    }

    public static Properties loadStoreProperties(Message m, boolean required, String storeProp1, String storeProp2) {
        if (m == null) {
            if (required) {
                throw new JoseException();
            }
            return null;
        }
        Properties props = null;
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)storeProp1, (String)storeProp2);
        if (propLoc != null) {
            try {
                props = JoseUtils.loadProperties(propLoc, m.getExchange().getBus());
            }
            catch (Exception ex) {
                LOG.warning("Properties resource is not identified");
                throw new JoseException(ex);
            }
        } else {
            String keyFile = (String)m.getContextualProperty("rs.security.keystore.file");
            if (keyFile != null) {
                String keyPassword;
                String keystorePassword;
                props = new Properties();
                props.setProperty("rs.security.keystore.file", keyFile);
                String type = (String)m.getContextualProperty("rs.security.keystore.type");
                if (type == null) {
                    type = "jwk";
                }
                props.setProperty("rs.security.keystore.type", type);
                String alias = (String)m.getContextualProperty("rs.security.keystore.alias");
                if (alias != null) {
                    props.setProperty("rs.security.keystore.alias", alias);
                }
                if ((keystorePassword = (String)m.getContextualProperty("rs.security.keystore.password")) != null) {
                    props.setProperty("rs.security.keystore.password", keystorePassword);
                }
                if ((keyPassword = (String)m.getContextualProperty("rs.security.key.password")) != null) {
                    props.setProperty("rs.security.key.password", keyPassword);
                }
            }
        }
        if (props == null) {
            if (required) {
                LOG.warning("Properties resource is not identified");
                throw new JoseException();
            }
            props = new Properties();
        }
        return props;
    }

    public static PrivateKey loadPrivateKey(Message m, Properties props, X509Certificate inCert, KeyOperation keyOper) {
        KeyStore ks = KeyManagementUtils.loadPersistKeyStore(m, props);
        try {
            String alias = ks.getCertificateAlias(inCert);
            return KeyManagementUtils.loadPrivateKey(ks, m, props, keyOper, alias);
        }
        catch (Exception ex) {
            LOG.warning("Private key can not be loaded");
            throw new JoseException(ex);
        }
    }

    public static X509Certificate getCertificateFromThumbprint(String thumbprint, String digestAlgorithm, Message m, Properties props) {
        KeyStore ks = KeyManagementUtils.loadPersistKeyStore(m, props);
        if (ks == null || thumbprint == null) {
            return null;
        }
        try {
            byte[] decodedThumbprint = Base64UrlUtility.decode((String)thumbprint);
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509cert;
                byte[] data;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = ks.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (cert = ks.getCertificate(alias)) != null) {
                    certs = new Certificate[]{cert};
                }
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate) || !Arrays.equals(data = MessageDigestUtils.createDigest((byte[])(x509cert = (X509Certificate)certs[0]).getEncoded(), (String)digestAlgorithm), decodedThumbprint)) continue;
                return x509cert;
            }
        }
        catch (KeyStoreException e) {
            LOG.log(Level.WARNING, "X509Certificate can not be loaded: ", e);
            throw new JoseException(e);
        }
        catch (CertificateEncodingException e) {
            LOG.log(Level.WARNING, "X509Certificate can not be loaded: ", e);
            throw new JoseException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.WARNING, "X509Certificate can not be loaded: ", e);
            throw new JoseException(e);
        }
        catch (Base64Exception e) {
            LOG.log(Level.WARNING, "X509Certificate can not be loaded: ", e);
            throw new JoseException(e);
        }
        return null;
    }

    public static void setSha1DigestHeader(JoseHeaders headers, Message m, Properties props) {
        String digest = KeyManagementUtils.loadDigestAndEncodeX509Certificate(m, props, "SHA-1");
        if (digest != null) {
            headers.setX509Thumbprint(digest);
        }
    }

    public static void setSha256DigestHeader(JoseHeaders headers, Message m, Properties props) {
        String digest = KeyManagementUtils.loadDigestAndEncodeX509Certificate(m, props, "SHA-256");
        if (digest != null) {
            headers.setX509ThumbprintSHA256(digest);
        }
    }
}

